<?php

namespace GenixCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Apexa Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class GENIX_CHOOSE_US extends Widget_Base
{

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'genix-choose';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Choose Us', 'genixcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'genix-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['genixcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['genixcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            '__tg_choose_img',
            [
                'label' => esc_html__('Choose Image', 'genixcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'choose_image',
            [
                'type' => Controls_Manager::MEDIA,
                'label' => esc_html__('Upload Image', 'genixcore'),
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->end_controls_section();

        // genix_section_title
        $this->start_controls_section(
            'genix_section_title',
            [
                'label' => esc_html__('Title & Content', 'genixcore'),
            ]
        );

        $this->add_control(
            'heading_animation',
            [
                'label' => esc_html__('Animation Effect', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'yes' => esc_html__('Yes', 'genixcore'),
                    'no' => esc_html__('No', 'genixcore'),
                ],
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'tg_sub_title',
            [
                'label' => esc_html__('Sub Title', 'genixcore'),
                'description' => genix_get_allowed_html_desc('intermediate'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Why Choose Our Services', 'genixcore'),
                'placeholder' => esc_html__('Type Heading Text', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tg_title',
            [
                'label' => esc_html__('Title', 'genixcore'),
                'description' => genix_get_allowed_html_desc('intermediate'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Where your financial dreams become reality', 'genixcore'),
                'placeholder' => esc_html__('Type Heading Text', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tg_desc',
            [
                'label' => esc_html__('Description', 'genixcore'),
                'description' => genix_get_allowed_html_desc('intermediate'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('We successfully cope with tasks of varying complexity provide area longerty guarantees and regularly master new Practice Following gies heur portfolio includes guarantees and regularly dozen.', 'genixcore'),
                'placeholder' => esc_html__('Type Heading Text', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tg_title_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'genixcore'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => esc_html__('H1', 'genixcore'),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2' => [
                        'title' => esc_html__('H2', 'genixcore'),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3' => [
                        'title' => esc_html__('H3', 'genixcore'),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4' => [
                        'title' => esc_html__('H4', 'genixcore'),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5' => [
                        'title' => esc_html__('H5', 'genixcore'),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6' => [
                        'title' => esc_html__('H6', 'genixcore'),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h2',
                'toggle' => false,
            ]
        );

        $this->add_responsive_control(
            'genix_align',
            [
                'label' => esc_html__('Alignment', 'genixcore'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'genixcore'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'genixcore'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'genixcore'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => false,
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '__tg_tab_section',
            [
                'label' => esc_html__('Choose Tabs', 'genixcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->start_controls_tabs(
            '_tab_style_top_box'
        );
        $repeater->start_controls_tab(
            '_tab_left_content',
            [
                'label' => esc_html__('Tab Button', 'genixcore'),
            ]
        );

        $repeater->add_control(
            'tab_text',
            [
                'label' => esc_html__('Button Text', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Focus On Goal', 'genixcore'),
                'label_block' => true,
            ]
        );

        $repeater->end_controls_tab();

        $repeater->start_controls_tab(
            '_tab_right_content',
            [
                'label' => esc_html__('Tab Content', 'genixcore'),
            ]
        );

        $repeater->add_control(
            'tab_desc',
            [
                'label' => esc_html__('Description', 'genixcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('longerty successfully cope with tasks of varying complexity provide area guarantees and regularly master new Practice.', 'genixcore'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tab_html',
            [
                'label' => esc_html__('Item List HTML', 'genixcore'),
                'type' => Controls_Manager::CODE,
                'language' => 'html',
                'rows' => 20,
            ]
        );

        $repeater->end_controls_tab();
        $repeater->end_controls_tabs();

        $this->add_control(
            'tg_tab_lists',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => esc_html__('Tab Item', 'genixcore'),
                'default' => [
                    [
                        [
                            'tab_text' => esc_html__('Focus On Goal', 'genixcore'),
                        ],
                        [
                            'tab_text' => esc_html__('Risk Management', 'genixcore'),
                        ],
                    ],
                ]
            ]
        );

        $this->end_controls_section();

        // Since
        $this->start_controls_section(
            'tg_since_box',
            [
                'label' => esc_html__('Since Box', 'genixcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'since_box_show',
            [
                'label' => esc_html__('Show Since Box', 'genixcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'genixcore'),
                'label_off' => esc_html__('Hide', 'genixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        if (genix_is_elementor_version('<', '2.6.0')) {
            $this->add_control(
                'tg_icon',
                [
                    'label' => esc_html__('Upload Icon', 'genixcore'),
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-globe',
                ]
            );
        } else {
            $this->add_control(
                'tg_selected_icon',
                [
                    'label' => esc_html__('Upload Icon', 'genixcore'),
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-globe',
                        'library' => 'solid',
                    ],
                ]
            );
        }

        $this->add_control(
            'since_text',
            [
                'label' => esc_html__('Since Text', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Since 1991 Operating In The World', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        // Shapes
        $this->start_controls_section(
            'tg_shape_img',
            [
                'label' => esc_html__('Background Shape', 'genixcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'tg_show_shapes',
            [
                'label' => esc_html__('Show Shape', 'genixcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'genixcore'),
                'label_off' => esc_html__('Hide', 'genixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'tg_shape_image',
            [
                'type' => Controls_Manager::MEDIA,
                'label' => esc_html__('Upload Shape 01', 'genixcore'),
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'tg_shape_image02',
            [
                'type' => Controls_Manager::MEDIA,
                'label' => esc_html__('Upload Shape 02', 'genixcore'),
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->end_controls_section();

        // style tab here
        $this->start_controls_section(
            '_section_style_content',
            [
                'label' => esc_html__('Title / Content', 'genixcore'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label' => esc_html__('Content Padding', 'genixcore'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .choose__content-two' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_background',
                'selector' => '{{WRAPPER}} .choose__content-two',
                'exclude' => [
                    'image'
                ]
            ]
        );

        // Subtitle
        $this->add_control(
            '_heading_subtitle',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__('Subtitle', 'genixcore'),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'subtitle_spacing',
            [
                'label' => esc_html__('Bottom Spacing', 'genixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .sub-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => esc_html__('Text Color', 'genixcore'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub-title',
                'selector' => '{{WRAPPER}} .sub-title',
            ]
        );

        // Title
        $this->add_control(
            '_heading_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__('Title', 'genixcore'),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => esc_html__('Bottom Spacing', 'genixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Text Color', 'genixcore'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title',
                'selector' => '{{WRAPPER}} .title',
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $this->add_render_attribute('title_args', 'class', 'title tg-element-title');

        $show_animation = ($settings['heading_animation'] == 'yes') ? 'animation-style' : 'animation-none';
?>

        <script>
            jQuery(document).ready(function($) {

                /*==========================================
                    =           Data Background     =
                =============================================*/
                $("[data-background]").each(function() {
                    $(this).css("background-image", "url(" + $(this).attr("data-background") + ")")
                })

            });
        </script>

        <section class="choose__area-two">
            <div class="choose__bg" data-background="<?php echo esc_url($settings['choose_image']['url']); ?>"></div>
            <div class="container">
                <div class="row justify-content-end">
                    <div class="col-lg-8 col-md-10">
                        <div class="choose__content-two">
                            <div class="section-title mb-20 tg-heading-subheading <?php echo esc_attr($show_animation) ?>3">
                                <?php if (!empty($settings['tg_sub_title'])) : ?>
                                    <span class="sub-title"><?php echo genix_kses($settings['tg_sub_title']); ?></span>
                                <?php endif; ?>
                                <?php
                                if (!empty($settings['tg_title'])) :
                                    printf(
                                        '<%1$s %2$s>%3$s</%1$s>',
                                        tag_escape($settings['tg_title_tag']),
                                        $this->get_render_attribute_string('title_args'),
                                        genix_kses($settings['tg_title'])
                                    );
                                endif;
                                ?>
                            </div>
                            <?php if (!empty($settings['tg_desc'])) : ?>
                                <p><?php echo genix_kses($settings['tg_desc']); ?></p>
                            <?php endif; ?>
                            <div class="choose__tab">
                                <ul class="nav nav-tabs" id="myTab" role="tablist">
                                    <?php foreach ($settings['tg_tab_lists'] as $key => $tab) :
                                        $active = ($key == 0) ? 'active' : '';
                                    ?>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link <?php echo esc_attr($active); ?>" id="goal-tab-<?php echo esc_attr($key); ?>" data-bs-toggle="tab" data-bs-target="#goal-<?php echo esc_attr($key); ?>" type="button" role="tab" aria-controls="goal-<?php echo esc_attr($key); ?>" aria-selected="true">
                                                <?php echo esc_html($tab['tab_text']); ?>
                                            </button>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                                <div class="tab-content" id="myTabContent">
                                    <?php foreach ($settings['tg_tab_lists'] as $key => $tab) :
                                        $active = ($key == 0) ? 'show active' : '';
                                    ?>
                                        <div class="tab-pane fade <?php echo esc_attr($active); ?>" id="goal-<?php echo esc_attr($key); ?>" role="tabpanel" aria-labelledby="goal-tab-<?php echo esc_attr($key); ?>" tabindex="0">
                                            <div class="choose__tab-content">
                                                <?php if (!empty($tab['tab_desc'])) : ?>
                                                    <p><?php echo genix_kses($tab['tab_desc']) ?></p>
                                                <?php endif; ?>
                                                <?php if (!empty($tab['tab_html'])) : ?>
                                                    <ul class="list-wrap">
                                                        <?php echo $tab['tab_html']; ?>
                                                    </ul>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                            <?php if (!empty($settings['since_box_show'])) : ?>
                                <div class="operating__box">
                                    <?php if (!empty($settings['tg_icon']) || !empty($settings['tg_selected_icon']['value'])) : ?>
                                        <div class="icon">
                                            <?php genix_render_icon($settings, 'tg_icon', 'tg_selected_icon'); ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['since_text'])) : ?>
                                        <div class="content">
                                            <p><?php echo genix_kses($settings['since_text']); ?></p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php if (!empty($settings['tg_show_shapes'])) : ?>
                <div class="choose__shape-wrap-two">
                    <?php if (!empty($settings['tg_shape_image']['url'])) : ?>
                        <img src="<?php echo esc_url($settings['tg_shape_image']['url']); ?>" alt="<?php echo esc_attr__('Image', 'genixcore') ?>" data-parallax='{"x" : -80 , "y" : 80 , "rotateZ":80}'>
                    <?php endif; ?>
                    <?php if (!empty($settings['tg_shape_image02']['url'])) : ?>
                        <img src="<?php echo esc_url($settings['tg_shape_image02']['url']); ?>" alt="<?php echo esc_attr__('Image', 'genixcore') ?>" data-aos="fade-left" data-aos-delay="400">
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </section>

<?php
    }
}

$widgets_manager->register(new GENIX_CHOOSE_US());
