<div class="tgmobile__menu">
    <nav class="tgmobile__menu-box">
        <div class="close-btn"><i class="fas fa-times"></i></div>
        <div class="nav-logo">
            <a href="<?php print esc_url(home_url('/')); ?>">
                <img src="<?php echo esc_url($genix_logo); ?>" alt="<?php echo esc_attr($genix_alt); ?>">
            </a>
        </div>
        <?php if (!empty($settings['mobile_search_show'])) : ?>
            <div class="tgmobile__search">
                <form method="get" action="<?php print esc_url(home_url('/')); ?>">
                    <input type="text" name="s" value="<?php print esc_attr(get_search_query()) ?>" placeholder="<?php echo esc_attr($settings['mobile_search_text']); ?>">
                    <button><i class="fas fa-search"></i></button>
                </form>
            </div>
        <?php endif; ?>
        <div class="tgmobile__menu-outer">
            <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
        </div>
        <div class="tgmobile__menu-bottom">

            <div class="contact-info">
                <ul class="list-wrap">
                    <?php if (!empty($settings['mobile_email'])) : ?>
                        <li><a href="mailto:<?php echo esc_attr($settings['mobile_email']); ?>"><?php echo genix_kses($settings['mobile_email']); ?></a></li>
                    <?php endif; ?>
                    <?php if (!empty($settings['mobile_phone'])) : ?>
                        <li><a href="tel:<?php echo esc_attr($settings['mobile_phone']); ?>"><?php echo genix_kses($settings['mobile_phone']); ?></a></li>
                    <?php endif; ?>
                </ul>
            </div>
            <?php if (!empty($settings['mobile_social_show'])) : ?>
                <div class="social-links">
                    <ul class="list-wrap">
                        <?php foreach ($settings['mobile_socials'] as $item) : ?>
                            <li>
                                <a href="<?php echo esc_url($item['tg_url2']); ?>" target="_blank">
                                    <?php genix_render_icon($item, 'tg_icon2', 'tg_selected_icon2'); ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>
        </div>
    </nav>
</div>
<div class="tgmobile__menu-backdrop"></div>