<?php

namespace GenixCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Apexa Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TG_Hero_Slider extends Widget_Base
{

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'hero-slider';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Hero Slider', 'genixcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'genix-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['genixcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['genixcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function register_controls()
    {

        // layout Panel
        $this->start_controls_section(
            'genix_layout',
            [
                'label' => esc_html__('Design Layout', 'genixcore'),
            ]
        );

        $this->add_control(
            'tg_design_style',
            [
                'label' => esc_html__('Select Layout', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'genixcore'),
                    'layout-2' => esc_html__('Layout 2', 'genixcore'),
                    'layout-3' => esc_html__('Layout 3', 'genixcore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        // Slider
        $this->start_controls_section(
            'tg_slider_area',
            [
                'label' => esc_html__('Slider Area', 'genixcore'),
                'condition' => [
                    'tg_design_style' => 'layout-1'
                ]
            ]
        );

        $slider = new \Elementor\Repeater();

        $slider->add_control(
            'slider_img',
            [
                'label' => esc_html__('Choose Background', 'genixcore'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $slider->add_control(
            'slider_sub_title',
            [
                'label' => esc_html__('Sub Title', 'genixcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('We Are Expert In This Field', 'genixcore'),
                'label_block' => true,
            ]
        );

        $slider->add_control(
            'slider_title',
            [
                'label' => esc_html__('Main Title', 'genixcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Transforming Dreams into Financial Reality', 'genixcore'),
                'label_block' => true,
            ]
        );

        $slider->add_control(
            'slider_desc',
            [
                'label' => esc_html__('Description', 'genixcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Agilos helps you to convert your data into a strategic asset and get business insights Agilos helps you to convert.', 'genixcore'),
                'label_block' => true,
            ]
        );

        $slider->add_control(
            'slider_button_show',
            [
                'label' => esc_html__('Show Button', 'genixcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'genixcore'),
                'label_off' => esc_html__('Hide', 'genixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $slider->add_control(
            'slider_btn_text',
            [
                'label' => esc_html__('Button Text', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Free Consulting', 'genixcore'),
                'title' => esc_html__('Enter button text', 'genixcore'),
                'label_block' => true,
                'condition' => [
                    'slider_button_show' => 'yes'
                ],
            ]
        );

        $slider->add_control(
            'slider_btn_link_type',
            [
                'label' => esc_html__('Button Link Type', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'label_block' => true,
                'condition' => [
                    'slider_button_show' => 'yes'
                ],
            ]
        );

        $slider->add_control(
            'slider_btn_link',
            [
                'label' => esc_html__('Button link', 'genixcore'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('https://your-link.com', 'genixcore'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'condition' => [
                    'slider_btn_link_type' => '1',
                    'slider_button_show' => 'yes'
                ],
                'label_block' => true,
            ]
        );

        $slider->add_control(
            'slider_btn_page_link',
            [
                'label' => esc_html__('Select Button Page', 'genixcore'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => genix_get_all_pages(),
                'condition' => [
                    'slider_btn_link_type' => '2',
                    'slider_button_show' => 'yes'
                ]
            ]
        );

        $slider->add_control(
            'slider_shape',
            [
                'label' => esc_html__('Choose Shape', 'genixcore'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $slider->add_control(
            'slider_shape2',
            [
                'label' => esc_html__('Choose Shape 02', 'genixcore'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'slider_info_lists',
            [
                'label' => esc_html__('Slider Lists', 'genixcore'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $slider->get_controls(),
                'default' => [
                    [
                        'slider_title' => esc_html__('Transforming Dreams into Financial Reality', 'genixcore'),
                    ],
                    [
                        'slider_title' => esc_html__('Transforming Dreams into Financial Reality', 'genixcore'),
                    ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'exclude' => ['custom'],
                'default' => 'full',
            ]
        );

        $this->end_controls_section();

        // Slider Two
        $this->start_controls_section(
            '__tg_slider_area02',
            [
                'label' => esc_html__('Slider Area', 'genixcore'),
                'condition' => [
                    'tg_design_style' => 'layout-2'
                ]
            ]
        );

        $slider2 = new \Elementor\Repeater();

        $slider2->add_control(
            'slider_img02',
            [
                'label' => esc_html__('Choose Background', 'genixcore'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $slider2->add_control(
            'slider_exp_year',
            [
                'label' => esc_html__('Exp Year', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('25', 'genixcore'),
                'label_block' => true,
            ]
        );

        $slider2->add_control(
            'slider_exp_text',
            [
                'label' => esc_html__('Exp Text', 'genixcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Years Experiences in this field', 'genixcore'),
                'label_block' => true,
            ]
        );

        $slider2->add_control(
            'slider_sub_title02',
            [
                'label' => esc_html__('Sub Title', 'genixcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('We Are Expert In This Field', 'genixcore'),
                'label_block' => true,
            ]
        );

        $slider2->add_control(
            'slider_title02',
            [
                'label' => esc_html__('Main Title', 'genixcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Solutions Financial For Business', 'genixcore'),
                'label_block' => true,
            ]
        );

        $slider2->add_control(
            'slider_desc02',
            [
                'label' => esc_html__('Description', 'genixcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Apexa helps you to convert your data into a strategic asset and get business insights Apexa helps you to convert your data into Asset and get Top-Notch Business Insights.', 'genixcore'),
                'label_block' => true,
            ]
        );

        $slider2->add_control(
            'slider_button_show02',
            [
                'label' => esc_html__('Show Button', 'genixcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'genixcore'),
                'label_off' => esc_html__('Hide', 'genixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $slider2->add_control(
            'slider_btn_text02',
            [
                'label' => esc_html__('Button Text', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Read more', 'genixcore'),
                'title' => esc_html__('Enter button text', 'genixcore'),
                'label_block' => true,
                'condition' => [
                    'slider_button_show02' => 'yes'
                ],
            ]
        );

        $slider2->add_control(
            'slider_btn_link_type02',
            [
                'label' => esc_html__('Button Link Type', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'label_block' => true,
                'condition' => [
                    'slider_button_show02' => 'yes'
                ],
            ]
        );

        $slider2->add_control(
            'slider_btn_link02',
            [
                'label' => esc_html__('Button link', 'genixcore'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('https://your-link.com', 'genixcore'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'condition' => [
                    'slider_btn_link_type02' => '1',
                    'slider_button_show02' => 'yes'
                ],
                'label_block' => true,
            ]
        );

        $slider2->add_control(
            'slider_btn_page_link02',
            [
                'label' => esc_html__('Select Button Page', 'genixcore'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => genix_get_all_pages(),
                'condition' => [
                    'slider_btn_link_type02' => '2',
                    'slider_button_show02' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'slider_info_lists02',
            [
                'label' => esc_html__('Slider Lists', 'genixcore'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $slider2->get_controls(),
                'default' => [
                    [
                        'slider_title02' => esc_html__('Solutions Financial For Business', 'genixcore'),
                    ],
                    [
                        'slider_title02' => esc_html__('Top experts from your country', 'genixcore'),
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        // Slider Three
        $this->start_controls_section(
            '__tg_slider_area03',
            [
                'label' => esc_html__('Slider Area', 'genixcore'),
                'condition' => [
                    'tg_design_style' => 'layout-3'
                ]
            ]
        );

        $slider3 = new \Elementor\Repeater();

        $slider3->add_control(
            'slider_img03',
            [
                'label' => esc_html__('Choose Background', 'genixcore'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $slider3->add_control(
            'slider_title03',
            [
                'label' => esc_html__('Main Title', 'genixcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => wp_kses_post('Transforming businesses with <span>cutting-edge IT</span> solutions', 'genixcore'),
                'label_block' => true,
            ]
        );

        $slider3->add_control(
            'slider_desc03',
            [
                'label' => esc_html__('Description', 'genixcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Empower your business with our comprehensive IT services and drive growth.', 'genixcore'),
                'label_block' => true,
            ]
        );

        $slider3->add_control(
            'slider_button_show03',
            [
                'label' => esc_html__('Show Button', 'genixcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'genixcore'),
                'label_off' => esc_html__('Hide', 'genixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $slider3->add_control(
            'slider_btn_text03',
            [
                'label' => esc_html__('Button Text', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Read more', 'genixcore'),
                'title' => esc_html__('Enter button text', 'genixcore'),
                'label_block' => true,
                'condition' => [
                    'slider_button_show03' => 'yes'
                ],
            ]
        );

        $slider3->add_control(
            'slider_btn_link_type03',
            [
                'label' => esc_html__('Button Link Type', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'label_block' => true,
                'condition' => [
                    'slider_button_show03' => 'yes'
                ],
            ]
        );

        $slider3->add_control(
            'slider_btn_link03',
            [
                'label' => esc_html__('Button link', 'genixcore'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('https://your-link.com', 'genixcore'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'condition' => [
                    'slider_btn_link_type03' => '1',
                    'slider_button_show03' => 'yes'
                ],
                'label_block' => true,
            ]
        );

        $slider3->add_control(
            'slider_btn_page_link03',
            [
                'label' => esc_html__('Select Button Page', 'genixcore'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => genix_get_all_pages(),
                'condition' => [
                    'slider_btn_link_type03' => '2',
                    'slider_button_show03' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'slider_info_lists03',
            [
                'label' => esc_html__('Slider Lists', 'genixcore'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $slider3->get_controls(),
                'default' => [
                    [
                        'slider_title03' => wp_kses_post('Transforming businesses with <span>cutting-edge IT</span> solutions', 'genixcore'),
                    ],
                    [
                        'slider_title03' => wp_kses_post('Transforming businesses with <span>cutting-edge IT</span> solutions', 'genixcore'),
                    ],
                ],
            ]
        );

        $this->end_controls_section();


        // TAB_STYLE
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', 'genixcore'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_transform',
            [
                'label' => esc_html__('Text Transform', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('None', 'genixcore'),
                    'uppercase' => esc_html__('UPPERCASE', 'genixcore'),
                    'lowercase' => esc_html__('lowercase', 'genixcore'),
                    'capitalize' => esc_html__('Capitalize', 'genixcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'text-transform: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // style tab here
        $this->start_controls_section(
            '_section_style_content',
            [
                'label' => esc_html__('Typography', 'genixcore'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        // Subtitle
        $this->add_control(
            '_heading_subtitle',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__('Subtitle', 'genixcore'),
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'subtitle_spacing',
            [
                'label' => esc_html__('Bottom Spacing', 'genixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .sub-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => esc_html__('Text Color', 'genixcore'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub-title',
                'selector' => '{{WRAPPER}} .sub-title',
            ]
        );

        // Title
        $this->add_control(
            '_heading_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__('Title', 'genixcore'),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => esc_html__('Bottom Spacing', 'genixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Text Color', 'genixcore'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title',
                'selector' => '{{WRAPPER}} .title',
            ]
        );

        // description
        $this->add_control(
            '_content_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__('Description', 'genixcore'),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'description_spacing',
            [
                'label' => esc_html__('Bottom Spacing', 'genixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .tg-content p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => esc_html__('Text Color', 'genixcore'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tg-content p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description',
                'selector' => '{{WRAPPER}} .tg-content p',
            ]
        );

        $this->end_controls_section();
    }


    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

?>

        <script>
            jQuery(document).ready(function($) {

                /*=============================================
                    =           Data Background             =
                =============================================*/
                $("[data-background]").each(function() {
                    $(this).css("background-image", "url(" + $(this).attr("data-background") + ")")
                })

            });
        </script>

        <?php if ($settings['tg_design_style'] == 'layout-2') : ?>

            <script>
                jQuery(document).ready(function($) {

                    var swiper3 = new Swiper(".slider_baner__active", {
                        spaceBetween: 0,
                        // effect: "fade",
                        loop: true,
                        autoplay: {
                            delay: 6000,
                        },
                        // Navigation arrows
                        navigation: {
                            nextEl: '.button-swiper-next',
                            prevEl: '.button-swiper-prev',
                        },
                        pagination: {
                            el: '.swiper-pagination-testimonials',
                            clickable: true
                        },
                    });

                });
            </script>

            <section class="slider__area">
                <div class="swiper-container slider_baner__active slider_baner_home6">
                    <div class="swiper-wrapper">
                        <?php foreach ($settings['slider_info_lists02'] as $item) :

                            // btn Link 01
                            if ('2' == $item['slider_btn_link_type02']) {
                                $link = get_permalink($item['slider_btn_page_link02']);
                                $target = '_self';
                                $rel = 'nofollow';
                            } else {
                                $link = !empty($item['slider_btn_link02']['url']) ? $item['slider_btn_link02']['url'] : '';
                                $target = !empty($item['slider_btn_link02']['is_external']) ? '_blank' : '';
                                $rel = !empty($item['slider_btn_link02']['nofollow']) ? 'nofollow' : '';
                            }
                        ?>
                            <div class="swiper-slide slider__single">
                                <div class="slider__bg" data-background="<?php echo esc_url($item['slider_img02']['url']); ?>"></div>
                                <div class="container">
                                    <div class="row">
                                        <div class="col-lg-7">
                                            <div class="banner__content-three">
                                                <div class="text-25-years">
                                                    <?php if (!empty($item['slider_exp_year'])) : ?>
                                                        <span class="text-stroke-2"><?php echo genix_kses($item['slider_exp_year']) ?></span>
                                                    <?php endif; ?>
                                                    <?php if (!empty($item['slider_exp_text'])) : ?>
                                                        <h4 class="text-experience"><?php echo genix_kses($item['slider_exp_text']) ?></h4>
                                                    <?php endif; ?>
                                                </div>
                                                <?php if (!empty($item['slider_sub_title02'])) : ?>
                                                    <span class="sub-title aos-init aos-animate"><?php echo genix_kses($item['slider_sub_title02']) ?></span>
                                                <?php endif; ?>
                                                <?php if (!empty($item['slider_title02'])) : ?>
                                                    <h2 class="title"><?php echo genix_kses($item['slider_title02']) ?></h2>
                                                <?php endif; ?>
                                                <?php if (!empty($item['slider_desc02'])) : ?>
                                                    <p><?php echo genix_kses($item['slider_desc02']) ?></p>
                                                <?php endif; ?>
                                                <?php if (!empty($item['slider_button_show02'])) : ?>
                                                    <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>" class='btn'><?php echo esc_html($item['slider_btn_text02']) ?></a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="box-button-slider-bottom">
                    <div class="container">
                        <div class="testimonial__nav-four">
                            <div class="testimonial-two-button-prev button-swiper-prev"><i class="flaticon-right-arrow"></i></div>
                            <div class="testimonial-two-button-next button-swiper-next"><i class="flaticon-right-arrow"></i></div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- slider-area-end -->

        <?php elseif ($settings['tg_design_style'] == 'layout-3') : ?>

            <script>
                jQuery(document).ready(function($) {

                    var swiper3 = new Swiper(".slider_baner__active", {
                        spaceBetween: 0,
                        // effect: "fade",
                        loop: true,
                        autoplay: {
                            delay: 6000,
                        },
                        // Navigation arrows
                        navigation: {
                            nextEl: '.button-swiper-next',
                            prevEl: '.button-swiper-prev',
                        },
                        pagination: {
                            el: '.swiper-pagination-testimonials',
                            clickable: true
                        },
                    });

                });

                if (jQuery(document).ready('#rangeValue').length) {
                    function rangeSlide(value) {
                        document.getElementById('rangeValue').innerHTML = value;
                    }
                }
            </script>

            <section class="slider__area slider__area-home8">
                <div class="swiper-container slider_baner__active slider_baner_home8">
                    <div class="swiper-wrapper">
                        <?php foreach ($settings['slider_info_lists03'] as $item) :

                            // btn Link 01
                            if ('2' == $item['slider_btn_link_type03']) {
                                $link = get_permalink($item['slider_btn_page_link03']);
                                $target = '_self';
                                $rel = 'nofollow';
                            } else {
                                $link = !empty($item['slider_btn_link03']['url']) ? $item['slider_btn_link03']['url'] : '';
                                $target = !empty($item['slider_btn_link03']['is_external']) ? '_blank' : '';
                                $rel = !empty($item['slider_btn_link03']['nofollow']) ? 'nofollow' : '';
                            }
                        ?>
                            <div class="swiper-slide slider__single">
                                <div class="slider__bg" data-background="<?php echo esc_url($item['slider_img03']['url']); ?>"></div>
                                <div class="container">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="banner__content-three">
                                                <?php if (!empty($item['slider_title03'])) : ?>
                                                    <h2 class="title">
                                                        <?php echo genix_kses($item['slider_title03']) ?>
                                                    </h2>
                                                <?php endif; ?>
                                                <?php if (!empty($item['slider_desc03'])) : ?>
                                                    <p><?php echo genix_kses($item['slider_desc03']) ?></p>
                                                <?php endif; ?>
                                                <?php if (!empty($item['slider_button_show03'])) : ?>
                                                    <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>" class='btn'><?php echo esc_html($item['slider_btn_text03']) ?></a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="box-button-slider-bottom">
                    <div class="testimonial__nav-four">
                        <div class="testimonial-two-button-prev button-swiper-prev">
                            <i class="flaticon-right-arrow"></i>
                        </div>
                        <div class="testimonial-two-button-next button-swiper-next">
                            <i class="flaticon-right-arrow"></i>
                        </div>
                    </div>
                </div>
            </section>


        <?php else : ?>

            <section class="slider__area">
                <div class="swiper-container slider__active">
                    <div class="swiper-wrapper">
                        <?php foreach ($settings['slider_info_lists'] as $item) :

                            if (!empty($item['slider_img']['url'])) {
                                $tg_slider_image_url = !empty($item['slider_img']['id']) ? wp_get_attachment_image_url($item['slider_img']['id'], $settings['thumbnail_size']) : $item['slider_img']['url'];
                                $tg_slider_image_alt = get_post_meta($item["slider_img"]["id"], "_wp_attachment_image_alt", true);
                            }

                            if (!empty($item['slider_shape']['url'])) {
                                $tg_slider_shape = !empty($item['slider_shape']['id']) ? wp_get_attachment_image_url($item['slider_shape']['id'], $settings['thumbnail_size']) : $item['slider_shape']['url'];
                                $tg_slider_shape_alt = get_post_meta($item["slider_shape"]["id"], "_wp_attachment_image_alt", true);
                            }

                            if (!empty($item['slider_shape2']['url'])) {
                                $tg_slider_shape2 = !empty($item['slider_shape2']['id']) ? wp_get_attachment_image_url($item['slider_shape2']['id'], $settings['thumbnail_size']) : $item['slider_shape2']['url'];
                                $tg_slider_shape_alt2 = get_post_meta($item["slider_shape2"]["id"], "_wp_attachment_image_alt", true);
                            }

                            // btn Link 01
                            if ('2' == $item['slider_btn_link_type']) {
                                $link = get_permalink($item['slider_btn_page_link']);
                                $target = '_self';
                                $rel = 'nofollow';
                            } else {
                                $link = !empty($item['slider_btn_link']['url']) ? $item['slider_btn_link']['url'] : '';
                                $target = !empty($item['slider_btn_link']['is_external']) ? '_blank' : '';
                                $rel = !empty($item['slider_btn_link']['nofollow']) ? 'nofollow' : '';
                            }
                        ?>
                            <div class="swiper-slide slider__single">
                                <div class="slider__bg" data-background="<?php echo esc_url($tg_slider_image_url); ?>"></div>
                                <div class="container">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="slider__content tg-content">
                                                <?php if (!empty($item['slider_sub_title'])) : ?>
                                                    <span class="sub-title"><?php echo genix_kses($item['slider_sub_title']) ?></span>
                                                <?php endif; ?>
                                                <?php if (!empty($item['slider_title'])) : ?>
                                                    <h2 class="title"><?php echo genix_kses($item['slider_title']) ?></h2>
                                                <?php endif; ?>
                                                <?php if (!empty($item['slider_desc'])) : ?>
                                                    <p><?php echo genix_kses($item['slider_desc']) ?></p>
                                                <?php endif; ?>
                                                <?php if (!empty($item['slider_button_show'])) : ?>
                                                    <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>" class="btn"><?php echo esc_html($item['slider_btn_text']) ?></a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="slider__shape">
                                    <?php if (!empty($tg_slider_shape)) : ?>
                                        <img src="<?php echo esc_url($tg_slider_shape); ?>" alt="<?php echo esc_attr($tg_slider_shape_alt) ?>">
                                    <?php endif; ?>
                                    <?php if (!empty($tg_slider_shape2)) : ?>
                                        <img src="<?php echo esc_url($tg_slider_shape2); ?>" alt="<?php echo esc_attr($tg_slider_shape_alt2) ?>">
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </section>

        <?php endif; ?>

<?php
    }
}

$widgets_manager->register(new TG_Hero_Slider());
