<?php

namespace GenixCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Apexa Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TG_IconList extends Widget_Base
{

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'iconlist';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Icon List', 'genixcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'genix-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['genixcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['genixcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function register_controls()
    {

        // layout Panel
        $this->start_controls_section(
            'tg_layout',
            [
                'label' => esc_html__('Design Layout', 'genixcore'),
            ]
        );
        $this->add_control(
            'tg_design_style',
            [
                'label' => esc_html__('Select Layout', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'genixcore'),
                    'layout-2' => esc_html__('Layout 2', 'genixcore'),
                    'layout-3' => esc_html__('Layout 3', 'genixcore'),
                    'layout-4' => esc_html__('Layout 4', 'genixcore'),
                    'layout-5' => esc_html__('Layout 5', 'genixcore'),
                    'layout-6' => esc_html__('Layout 6', 'genixcore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        // _tg_list 01
        $this->start_controls_section(
            '_tg_icon_box',
            [
                'label' => esc_html__('Icon List', 'genixcore'),
                'condition' => [
                    'tg_design_style!' => ['layout-3', 'layout-6']
                ]
            ]
        );

        if (genix_is_elementor_version('<', '2.6.0')) {
            $this->add_control(
                'item_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fas fa-arrow-right',
                ]
            );
        } else {
            $this->add_control(
                'item_selected_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'flaticon-target',
                        'library' => 'solid',
                    ],
                ]
            );
        }

        $this->add_control(
            'tg_title',
            [
                'label' => esc_html__('Title', 'genixcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Business Solutions', 'genixcore'),
                'placeholder' => esc_html__('Type list text', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tg_desc',
            [
                'label' => esc_html__('Description', 'genixcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Semper egetuis tellus urna condi', 'genixcore'),
                'placeholder' => esc_html__('Type list desc', 'genixcore'),
                'label_block' => true,
            ]
        );


        $this->end_controls_section();

        // _tg_list 02
        $this->start_controls_section(
            '_tg_icon_list',
            [
                'label' => esc_html__('Icon List', 'genixcore'),
                'condition' => [
                    'tg_design_style' => ['layout-3', 'layout-6']
                ]
            ]
        );

        $repeater = new \Elementor\Repeater();

        if (genix_is_elementor_version('<', '2.6.0')) {
            $repeater->add_control(
                'tg_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fas fa-arrow-right',
                ]
            );
        } else {
            $repeater->add_control(
                'tg_selected_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'flaticon-arrow-button',
                        'library' => 'solid',
                    ],
                ]
            );
        }

        $repeater->add_control(
            'repeater_title',
            [
                'label' => esc_html__('Title', 'genixcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Challenge Business Growth', 'genixcore'),
                'placeholder' => esc_html__('Type list text', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'item_lists',
            [
                'label' => esc_html__('Item Lists', 'genixcore'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'repeater_title' => esc_html__('Challenge Business Growth', 'genixcore'),
                    ],
                    [
                        'repeater_title' => esc_html__('Analysis & Research', 'genixcore'),
                    ],
                    [
                        'repeater_title' => esc_html__('Finance Security Solutions', 'genixcore'),
                    ],
                    [
                        'repeater_title' => esc_html__('100% Money Growth', 'genixcore'),
                    ],
                ],
            ]
        );

        $this->end_controls_section();


        // Style Tab
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', 'genixcore'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_transform',
            [
                'label' => esc_html__('Text Transform', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('None', 'genixcore'),
                    'uppercase' => esc_html__('UPPERCASE', 'genixcore'),
                    'lowercase' => esc_html__('lowercase', 'genixcore'),
                    'capitalize' => esc_html__('Capitalize', 'genixcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'text-transform: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Text Color', 'genixcore'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .choose-list .title' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'tg_design_style!' => ['layout-3', 'layout-6']
                ]
            ]
        );

        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__('Description Color', 'genixcore'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .choose-list p' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'tg_design_style!' => ['layout-3', 'layout-6']
                ]
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

?>

        <?php if ($settings['tg_design_style']  == 'layout-2') : ?>


            <div class="choose-list">
                <ul class="list-wrap">
                    <li>
                        <?php if (!empty($settings['item_icon']) || !empty($settings['item_selected_icon']['value'])) : ?>
                            <div class="icon">
                                <?php genix_render_icon($settings, 'item_icon', 'item_selected_icon'); ?>
                            </div>
                        <?php endif; ?>
                        <div class="content">
                            <?php if (!empty($settings['tg_title'])) : ?>
                                <h4 class="title"><?php echo genix_kses($settings['tg_title']); ?></h4>
                            <?php endif; ?>
                            <?php if (!empty($settings['tg_desc'])) : ?>
                                <p><?php echo genix_kses($settings['tg_desc']); ?></p>
                            <?php endif; ?>
                        </div>
                    </li>
                </ul>
            </div>


        <?php elseif ($settings['tg_design_style']  == 'layout-3') : ?>

            <div class="about__list-box">
                <ul class="list-wrap">
                    <?php foreach ($settings['item_lists'] as $item) : ?>
                        <li>
                            <?php if (!empty($item['tg_icon']) || !empty($item['tg_selected_icon']['value'])) : ?>
                                <?php genix_render_icon($item, 'tg_icon', 'tg_selected_icon'); ?>
                            <?php endif; ?>
                            <?php echo genix_kses($item['repeater_title']); ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>

        <?php elseif ($settings['tg_design_style']  == 'layout-4') : ?>

            <div class="choose__list-box">
                <?php if (!empty($settings['item_icon']) || !empty($settings['item_selected_icon']['value'])) : ?>
                    <div class="choose__list-icon">
                        <?php genix_render_icon($settings, 'item_icon', 'item_selected_icon'); ?>
                    </div>
                <?php endif; ?>
                <div class="choose__list-content">
                    <?php if (!empty($settings['tg_title'])) : ?>
                        <h4 class="title"><?php echo genix_kses($settings['tg_title']); ?></h4>
                    <?php endif; ?>
                    <?php if (!empty($settings['tg_desc'])) : ?>
                        <p><?php echo genix_kses($settings['tg_desc']); ?></p>
                    <?php endif; ?>
                </div>
            </div>

        <?php elseif ($settings['tg_design_style']  == 'layout-5') : ?>

            <div class="about__satisfied-box">
                <?php if (!empty($settings['item_icon']) || !empty($settings['item_selected_icon']['value'])) : ?>
                    <div class="icon">
                        <?php genix_render_icon($settings, 'item_icon', 'item_selected_icon'); ?>
                    </div>
                <?php endif; ?>
                <div class="content">
                    <?php if (!empty($settings['tg_title'])) : ?>
                        <h2 class="title"><?php echo genix_kses($settings['tg_title']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($settings['tg_desc'])) : ?>
                        <p><?php echo genix_kses($settings['tg_desc']); ?></p>
                    <?php endif; ?>
                </div>
            </div>

        <?php elseif ($settings['tg_design_style']  == 'layout-6') : ?>

            <div class="about__list-box about__list-box-three">
                <ul class="list-wrap">
                    <?php foreach ($settings['item_lists'] as $item) : ?>
                        <li>
                            <?php if (!empty($item['tg_icon']) || !empty($item['tg_selected_icon']['value'])) : ?>
                                <?php genix_render_icon($item, 'tg_icon', 'tg_selected_icon'); ?>
                            <?php endif; ?>
                            <?php echo genix_kses($item['repeater_title']); ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>

        <?php else : ?>

            <div class="about-list">
                <ul class="list-wrap">
                    <li>
                        <?php if (!empty($settings['item_icon']) || !empty($settings['item_selected_icon']['value'])) : ?>
                            <div class="icon">
                                <?php genix_render_icon($settings, 'item_icon', 'item_selected_icon'); ?>
                            </div>
                        <?php endif; ?>
                        <div class="content">
                            <?php if (!empty($settings['tg_title'])) : ?>
                                <h4 class="title"><?php echo genix_kses($settings['tg_title']); ?></h4>
                            <?php endif; ?>
                            <?php if (!empty($settings['tg_desc'])) : ?>
                                <p><?php echo genix_kses($settings['tg_desc']); ?></p>
                            <?php endif; ?>
                        </div>
                    </li>
                </ul>
            </div>

        <?php endif; ?>


<?php
    }
}

$widgets_manager->register(new TG_IconList());
