<?php

namespace GenixCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Apexa Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TG_ServicesBox extends Widget_Base
{

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tg-servicesBox';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Services Box', 'genixcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'genix-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['genixcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['genixcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function register_controls()
    {

        // layout Panel
        $this->start_controls_section(
            'tg_layout',
            [
                'label' => esc_html__('Design Layout', 'genixcore'),
            ]
        );
        $this->add_control(
            'tg_design_style',
            [
                'label' => esc_html__('Select Layout', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'genixcore'),
                    'layout-2' => esc_html__('Layout 2', 'genixcore'),
                    'layout-3' => esc_html__('Layout 3', 'genixcore'),
                    'layout-4' => esc_html__('Layout 4', 'genixcore'),
                    'layout-5' => esc_html__('Layout 5', 'genixcore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        // Style_group
        $this->start_controls_section(
            'tg_servicesBox_group',
            [
                'label' => esc_html__('Services Group', 'genixcore'),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'select_post',
            [
                'label' => __('Must be Select a Post', 'genixcore'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'default' => 'none',
                'options' => $this->get_all_services(),
            ]
        );

        if (genix_is_elementor_version('<', '2.6.0')) {
            $repeater->add_control(
                'tg_icon',
                [
                    'label' => esc_html__('Upload Icon', 'genixcore'),
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-star',
                ]
            );
        } else {
            $repeater->add_control(
                'tg_selected_icon',
                [
                    'label' => esc_html__('Upload Icon', 'genixcore'),
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'flaticon-profit',
                        'library' => 'solid',
                    ],
                ]
            );
        }

        $repeater->add_control(
            'description',
            [
                'label' => esc_html__('Short Description', 'genixcore'),
                'description' => esc_html__('Morem ipsum dolor sittemet consectetur adipiscing.', 'genixcore'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'button_text',
            [
                'label' => esc_html__('Button Text', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Read More', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tg_post_list',
            [
                'label' => esc_html__('All Post List', 'genixcore'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'description' => esc_html__('Morem ipsum dolor sittemet consectetur adipiscing.', 'genixcore'),
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        // Style TAB
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', 'genixcore'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_transform',
            [
                'label' => esc_html__('Text Transform', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('None', 'genixcore'),
                    'uppercase' => esc_html__('UPPERCASE', 'genixcore'),
                    'lowercase' => esc_html__('lowercase', 'genixcore'),
                    'capitalize' => esc_html__('Capitalize', 'genixcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'text-transform: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }


    // Get All Services
    public function get_all_services()
    {

        $wp_query = get_posts([
            'post_type' => 'services',
            'orderby' => 'date',
            'posts_per_page' => -1,
        ]);

        $options = ['none' => 'None'];
        foreach ($wp_query as $services) {
            $options[$services->ID] = $services->post_name;
        }

        return $options;
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

?>

        <?php if ($settings['tg_design_style']  == 'layout-2') : ?>

            <div class="row justify-content-center gutter-24">
                <?php foreach ($settings['tg_post_list'] as $items) : ?>

                    <?php
                    $args = new \WP_Query(array(
                        'post_type' => 'services',
                        'post_status' => 'publish',
                        'post__in' => [
                            $items['select_post']
                        ]
                    ));

                    /* Start the Loop */
                    while ($args->have_posts()) : $args->the_post();
                    ?>
                        <div class="col-xl-3 col-lg-4 col-md-6">
                            <div class="services__item-two">
                                <?php if (!empty($items['tg_icon']) || !empty($items['tg_selected_icon']['value'])) : ?>
                                    <div class="services__icon-two">
                                        <?php genix_render_icon($items, 'tg_icon', 'tg_selected_icon'); ?>
                                    </div>
                                <?php endif; ?>
                                <div class="services__content-two">
                                    <h2 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                    <?php if (!empty($items['description'])) : ?>
                                        <p><?php echo genix_kses($items['description']); ?></p>
                                    <?php endif; ?>
                                    <?php if (!empty($items['button_text'])) : ?>
                                        <a href="<?php the_permalink(); ?>" class="btn"><?php echo esc_html($items['button_text']) ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endwhile;
                    wp_reset_postdata(); ?>

                <?php endforeach; ?>
            </div>

        <?php elseif ($settings['tg_design_style']  == 'layout-3') : ?>

            <div class="row justify-content-center gutter-24">
                <?php foreach ($settings['tg_post_list'] as $items) : ?>

                    <?php
                    $args = new \WP_Query(array(
                        'post_type' => 'services',
                        'post_status' => 'publish',
                        'post__in' => [
                            $items['select_post']
                        ]
                    ));

                    /* Start the Loop */
                    while ($args->have_posts()) : $args->the_post();
                    ?>
                        <div class="col-lg-4 col-md-6">
                            <div class="services__item-three">
                                <div class="services__item-top">
                                    <?php if (!empty($items['tg_icon']) || !empty($items['tg_selected_icon']['value'])) : ?>
                                        <div class="services__icon-three">
                                            <?php genix_render_icon($items, 'tg_icon', 'tg_selected_icon'); ?>
                                        </div>
                                    <?php endif; ?>
                                    <div class="services__item-top-title">
                                        <h2 class="title">
                                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        </h2>
                                    </div>
                                </div>
                                <div class="services__content-three">
                                    <?php if (!empty($items['description'])) : ?>
                                        <p><?php echo genix_kses($items['description']); ?></p>
                                    <?php endif; ?>
                                    <?php if (!empty($items['button_text'])) : ?>
                                        <a href="<?php the_permalink(); ?>" class="btn btn-two"><?php echo esc_html($items['button_text']) ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endwhile;
                    wp_reset_postdata(); ?>

                <?php endforeach; ?>
            </div>

        <?php elseif ($settings['tg_design_style']  == 'layout-4') : ?>

            <div class="services__item-wrap-two">
                <div class="row justify-content-center gutter-24">
                    <?php foreach ($settings['tg_post_list'] as $items) : ?>

                        <?php
                        $args = new \WP_Query(array(
                            'post_type' => 'services',
                            'post_status' => 'publish',
                            'post__in' => [
                                $items['select_post']
                            ]
                        ));

                        /* Start the Loop */
                        while ($args->have_posts()) : $args->the_post();
                        ?>
                            <div class="col-xl-3 col-lg-4 col-md-6">
                                <div class="services__item-five">
                                    <?php if (!empty($items['tg_icon']) || !empty($items['tg_selected_icon']['value'])) : ?>
                                        <div class="services__icon-five">
                                            <?php genix_render_icon($items, 'tg_icon', 'tg_selected_icon'); ?>
                                            <div class="services__icon-shape">
                                                <div class="shape one">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="100" height="89" viewBox="0 0 100 89" fill="none">
                                                        <path d="M89.3997 20.1665C90.5806 21.4322 91.2497 23.0786 91.2607 24.7458C91.2717 26.4129 90.6237 27.965 89.4585 29.0627L82.7168 35.3787C83.8857 34.2836 85.4772 33.7354 87.141 33.8548C88.8049 33.9742 90.4049 34.7514 91.589 36.0153C92.7732 37.2792 93.4445 38.9265 93.4553 40.5946C93.4661 42.2627 92.8154 43.815 91.6465 44.9101L89.4391 46.9782C90.7021 46.1158 92.2814 45.7931 93.8594 46.075C95.4374 46.3569 96.897 47.2225 97.9445 48.4977C98.9919 49.7729 99.5496 51.363 99.5051 52.948C99.4607 54.5331 98.8175 55.9955 97.705 57.041L66.4218 86.3494C65.306 87.3914 63.8048 87.938 62.2202 87.8791C60.6357 87.8202 59.0853 87.1602 57.881 86.0319C56.6767 84.9037 55.908 83.3908 55.7294 81.7978C55.5509 80.2048 55.9757 78.6498 56.9185 77.4457L46.2874 87.4056C45.1185 88.5008 43.5271 89.0489 41.8632 88.9295C40.1994 88.8101 38.5994 88.033 37.4152 86.769C36.2311 85.5051 35.5598 83.8579 35.549 82.1898C35.5382 80.5217 36.1888 78.9693 37.3578 77.8742L42.5545 73.0055C41.5403 73.9509 40.2052 74.4903 38.7733 74.5334C37.3414 74.5764 35.8998 74.1205 34.6905 73.242C33.4812 72.3636 32.5777 71.1161 32.1318 69.7089C31.6858 68.3017 31.7245 66.8205 32.2413 65.5139L22.1964 74.9247C21.0275 76.0198 19.4361 76.5679 17.7722 76.4485C16.1084 76.3291 14.5084 75.552 13.3242 74.2881C12.1401 73.0241 11.4688 71.3769 11.458 69.7088C11.4472 68.0407 12.0978 66.4883 13.2667 65.3932L25.0674 54.3375C23.8985 55.4326 22.3071 55.9808 20.6432 55.8614C18.9794 55.742 17.3794 54.9649 16.1952 53.7009C15.0111 52.437 14.3398 50.7898 14.329 49.1217C14.3182 47.4536 14.9688 45.9012 16.1377 44.8061L11.4359 49.2111C10.267 50.3062 8.67555 50.8544 7.01169 50.735C5.34784 50.6156 3.74784 49.8384 2.56369 48.5745C1.37954 47.3106 0.708235 45.6633 0.697453 43.9952C0.686672 42.3271 1.3373 40.7748 2.5062 39.6797L35.5613 8.71135C36.7302 7.61624 38.3217 7.06808 39.9855 7.18747C41.6494 7.30686 43.2494 8.08401 44.4335 9.34795C45.6177 10.6119 46.289 12.2591 46.2998 13.9272C46.3105 15.5953 45.6599 17.1477 44.491 18.2428L61.4956 2.31173C62.6645 1.21663 64.2559 0.668477 65.9198 0.787863C67.5836 0.90725 69.1836 1.6844 70.3678 2.94834C71.5519 4.21229 72.2232 5.8595 72.234 7.5276C72.2448 9.19571 71.5942 10.7481 70.4253 11.8432L65.2285 16.7119C66.242 15.7657 67.5766 15.2252 69.0084 15.181C70.4403 15.1369 71.8821 15.5918 73.092 16.4694C74.3019 17.3471 75.2063 18.594 75.6532 20.001C76.1001 21.4079 76.0625 22.8893 75.5466 24.1964L80.5275 19.5299C81.699 18.4397 83.2895 17.8948 84.9518 18.014C86.6141 18.1333 88.2131 18.9071 89.3997 20.1665Z" fill="currentcolor" />
                                                    </svg>
                                                </div>
                                                <div class="shape two">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" viewBox="0 0 8 8" fill="none">
                                                        <path d="M7.36755 4.37738C7.36755 6.02099 6.03514 7.3534 4.39153 7.3534C2.74792 7.3534 1.41552 6.02099 1.41552 4.37738C1.41552 2.73376 2.74792 1.40136 4.39153 1.40136C6.03514 1.40136 7.36755 2.73376 7.36755 4.37738Z" stroke="currentcolor" stroke-width="1.19041" />
                                                    </svg>
                                                </div>
                                                <div class="shape three rotateme">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="9" height="9" viewBox="0 0 9 9" fill="none">
                                                        <path d="M1.70898 1.73877L7.06581 7.0956M1.70898 7.0956L7.06581 1.73877" stroke="currentcolor" stroke-width="1.92846" stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <div class="services__content-five">
                                        <h2 class="title">
                                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        </h2>
                                        <?php if (!empty($items['description'])) : ?>
                                            <p><?php echo genix_kses($items['description']); ?></p>
                                        <?php endif; ?>
                                        <?php if (!empty($items['button_text'])) : ?>
                                            <a href="<?php the_permalink(); ?>" class="btn"><?php echo esc_html($items['button_text']) ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile;
                        wp_reset_postdata(); ?>

                    <?php endforeach; ?>
                </div>
            </div>

        <?php elseif ($settings['tg_design_style']  == 'layout-5') : ?>

            <div class="services__item-wrap-two">
                <div class="row justify-content-center gutter-24">
                    <?php foreach ($settings['tg_post_list'] as $items) : ?>

                        <?php
                        $args = new \WP_Query(array(
                            'post_type' => 'services',
                            'post_status' => 'publish',
                            'post__in' => [
                                $items['select_post']
                            ]
                        ));

                        /* Start the Loop */
                        while ($args->have_posts()) : $args->the_post();
                        ?>
                            <div class="col-xl-4 col-lg-4 col-md-6">
                                <div class="services__item-five services__item-six">
                                    <?php if (!empty($items['tg_icon']) || !empty($items['tg_selected_icon']['value'])) : ?>
                                        <div class="services__icon-five">
                                            <div class="icon">
                                                <?php genix_render_icon($items, 'tg_icon', 'tg_selected_icon'); ?>
                                            </div>
                                            <div class="services__icon-shape">
                                                <div class="shape one">
                                                    <svg width="68" height="78" viewBox="0 0 68 78" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M31.1376 1.6526C32.9089 0.629968 35.0911 0.629967 36.8624 1.6526L64.9126 17.8474C66.6839 18.87 67.775 20.7599 67.775 22.8052V55.1948C67.775 57.2401 66.6839 59.13 64.9126 60.1526L36.8624 76.3474C35.0911 77.37 32.9089 77.37 31.1376 76.3474L3.0874 60.1526C1.31615 59.13 0.22501 57.2401 0.22501 55.1948V22.8052C0.22501 20.7599 1.31614 18.87 3.08739 17.8474L31.1376 1.6526Z" fill="#FEF6E6" />
                                                    </svg>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <div class="services__content-five">
                                        <h2 class="title">
                                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        </h2>
                                        <?php if (!empty($items['description'])) : ?>
                                            <p><?php echo genix_kses($items['description']); ?></p>
                                        <?php endif; ?>
                                        <?php if (!empty($items['button_text'])) : ?>
                                            <a href="<?php the_permalink(); ?>" class="btn"><?php echo esc_html($items['button_text']) ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile;
                        wp_reset_postdata(); ?>

                    <?php endforeach; ?>
                </div>
            </div>

        <?php else : ?>

            <div class="services-item-wrap">
                <div class="row justify-content-center">
                    <?php foreach ($settings['tg_post_list'] as $items) : ?>

                        <?php
                        $args = new \WP_Query(array(
                            'post_type' => 'services',
                            'post_status' => 'publish',
                            'post__in' => [
                                $items['select_post']
                            ]
                        ));

                        /* Start the Loop */
                        while ($args->have_posts()) : $args->the_post();
                        ?>
                            <div class="col-xl-3 col-lg-4 col-md-6 col-sm-8">
                                <div class="services-item shine-animate-item">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <div class="services-thumb">
                                            <a href="<?php the_permalink(); ?>" class="shine-animate">
                                                <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(), ''); ?>" alt="<?php echo esc_attr__('Image', 'genixcore') ?>">
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                    <div class="services-content">
                                        <?php if (!empty($items['tg_icon']) || !empty($items['tg_selected_icon']['value'])) : ?>
                                            <div class="icon">
                                                <?php genix_render_icon($items, 'tg_icon', 'tg_selected_icon'); ?>
                                            </div>
                                        <?php endif; ?>
                                        <h4 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                        <?php if (!empty($items['description'])) : ?>
                                            <p><?php echo genix_kses($items['description']); ?></p>
                                        <?php endif; ?>
                                        <?php if (!empty($items['button_text'])) : ?>
                                            <a href="<?php the_permalink(); ?>" class="btn"><?php echo esc_html($items['button_text']) ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile;
                        wp_reset_postdata(); ?>

                    <?php endforeach; ?>
                </div>
            </div>

        <?php endif; ?>

<?php
    }
}

$widgets_manager->register(new TG_ServicesBox());
