<?php

namespace GenixCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Utils;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Background;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Apexa Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TG_PHONE extends Widget_Base
{

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tg-phone';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Phone Number', 'genixcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'genix-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['genixcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['genixcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function register_controls()
    {

        // layout Panel
        $this->start_controls_section(
            'genix_layout',
            [
                'label' => esc_html__('Design Layout', 'genixcore'),
            ]
        );
        $this->add_control(
            'tg_design_style',
            [
                'label' => esc_html__('Select Layout', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'genixcore'),
                    'layout-2' => esc_html__('Layout 2', 'genixcore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        // tg_phone_group
        $this->start_controls_section(
            'tg_phone_group',
            [
                'label' => esc_html__('Phone', 'genixcore'),
            ]
        );

        $this->add_control(
            'tg_phone_text',
            [
                'label' => esc_html__('Phone Text', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Toll Free Call', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tg_phone_number',
            [
                'label' => esc_html__('Phone Number', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('+ 88 ( 9600 ) 6002', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->add_responsive_control(
            'tg_align',
            [
                'label' => esc_html__('Alignment', 'genixcore'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__('Left', 'genixcore'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'genixcore'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-end' => [
                        'title' => esc_html__('Right', 'genixcore'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'flex-start',
                'toggle' => false,
                'selectors' => [
                    '{{WRAPPER}} .tg-phone' => 'justify-content: {{VALUE}};',
                    '{{WRAPPER}} .about__phone' => 'justify-content: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();

        // Style TAB
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', 'genixcore'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_transform',
            [
                'label' => esc_html__('Text Transform', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('None', 'genixcore'),
                    'uppercase' => esc_html__('UPPERCASE', 'genixcore'),
                    'lowercase' => esc_html__('lowercase', 'genixcore'),
                    'capitalize' => esc_html__('Capitalize', 'genixcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'text-transform: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {

        $settings = $this->get_settings_for_display();

?>

        <?php if ($settings['tg_design_style'] == 'layout-2') : ?>
            <div class="about__phone">
                <div class="icon">
                    <i class="flaticon-phone-call"></i>
                </div>
                <div class="content">
                    <?php if (!empty($settings['tg_phone_text'])) : ?>
                        <span><?php echo esc_html($settings['tg_phone_text']) ?></span>
                    <?php endif; ?>
                    <?php if (!empty($settings['tg_phone_number'])) : ?>
                        <a href="tel:<?php echo esc_attr($settings['tg_phone_number']) ?>"><?php echo esc_html($settings['tg_phone_number']) ?></a>
                    <?php endif; ?>
                </div>
            </div>
        <?php else : ?>
            <div class="tg-phone">
                <div class="icon">
                    <i class="flaticon-phone-call"></i>
                </div>
                <div class="content">
                    <?php if (!empty($settings['tg_phone_text'])) : ?>
                        <span><?php echo esc_html($settings['tg_phone_text']) ?></span>
                    <?php endif; ?>
                    <?php if (!empty($settings['tg_phone_number'])) : ?>
                        <a href="tel:<?php echo esc_attr($settings['tg_phone_number']) ?>"><?php echo esc_html($settings['tg_phone_number']) ?></a>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
<?php
    }
}

$widgets_manager->register(new TG_PHONE());
