<?php

namespace GenixCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Apexa Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TG_MARQUEE extends Widget_Base
{

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tg-marquee';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Marquee Text', 'genixcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'genix-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['genixcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['genixcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function register_controls()
    {

        // layout Panel
        $this->start_controls_section(
            'tg_layout',
            [
                'label' => esc_html__('Design Layout', 'genixcore'),
            ]
        );
        $this->add_control(
            'tg_design_style',
            [
                'label' => esc_html__('Select Layout', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'genixcore'),
                    'layout-2' => esc_html__('Layout 2', 'genixcore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        // _tg_marquee
        $this->start_controls_section(
            '_tg_marquee',
            [
                'label' => esc_html__('Marquee', 'genixcore'),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'marquee_title',
            [
                'label' => esc_html__('Title', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Marketing', 'genixcore'),
                'placeholder' => esc_html__('Type Title', 'genixcore'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'marquee_url',
            [
                'label' => esc_html__('URL', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'genixcore'),
                'placeholder' => esc_html__('Type URL', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tg_marquee_list',
            [
                'label' => esc_html__('Progress Lists', 'genixcore'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'marquee_title' => esc_html__('Marketing', 'genixcore'),
                    ],
                    [
                        'marquee_title' => esc_html__('Finance Advisor', 'genixcore'),
                    ],
                    [
                        'marquee_title' => esc_html__('Investment', 'genixcore'),
                    ],
                    [
                        'marquee_title' => esc_html__('Target', 'genixcore'),
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', 'genixcore'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_transform',
            [
                'label' => esc_html__('Text Transform', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('None', 'genixcore'),
                    'uppercase' => esc_html__('UPPERCASE', 'genixcore'),
                    'lowercase' => esc_html__('lowercase', 'genixcore'),
                    'capitalize' => esc_html__('Capitalize', 'genixcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'text-transform: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display(); ?>


        <?php if ($settings['tg_design_style']  == 'layout-2') : ?>


            <script>
                jQuery(document).ready(function($) {

                    var swiper4 = new Swiper(".slider_partners__active", {
                        spaceBetween: 0,
                        slidesPerView: "auto",

                        // effect: "fade",
                        loop: true,
                        autoplay: {
                            delay: 6000,
                        },
                        // Navigation arrows
                        navigation: {
                            nextEl: '.button-swiper-next',
                            prevEl: '.button-swiper-prev',
                        },
                    });

                });
            </script>

            <div class="box-swiper">
                <div class="swiper-container slider_partners__active">
                    <div class="swiper-wrapper">
                        <?php foreach ($settings['tg_marquee_list'] as $item) : ?>
                            <div class="swiper-slide slider__partner">
                                <h4 class="text-stroke">
                                    <svg width="46" height="46" viewBox="0 0 46 46" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M24.4057 0.5V18.1759L23.0116 19.5701L21.5614 18.1199V0.5H24.4057ZM21.5614 19.5341L22.3045 20.2772L22.0202 20.5614H21.5614V19.5341ZM20.5614 18.5341V20.5614H18.5663L6.08471 8.0798L8.0959 6.06861L20.5614 18.5341ZM19.5663 21.5614H20.5614V22.0202L20.2933 22.2884L19.5663 21.5614ZM23.7187 20.2772L24.4057 19.5901V20.5614H24.0029L23.7187 20.2772ZM25.4057 20.5614V18.5901L37.911 6.08484L39.9222 8.09603L27.4568 20.5614H25.4057ZM25.4057 21.9642V21.5614H26.4568L25.7299 22.2884L25.4057 21.9642ZM23.5887 21.5614L24.4057 22.3784V23.6125L23.6125 24.4057H22.4106L21.5614 23.5565V22.4344L22.4344 21.5614H23.5887ZM20.2933 23.7026L20.5614 23.9707V24.4057H19.5901L20.2933 23.7026ZM18.5901 25.4057H20.5614V27.4568L8.1027 39.9155L6.09151 37.9043L18.5901 25.4057ZM21.5614 26.4568V25.4057H21.9964L22.3045 25.7138L21.5614 26.4568ZM21.5614 45.5V27.871L23.0116 26.4209L24.4057 27.815V45.5H21.5614ZM24.4057 26.4008L23.7187 25.7138L24.0267 25.4057H24.4057V26.4008ZM25.4057 27.4008V25.4057H27.433L39.9154 37.8881L37.9042 39.8993L25.4057 27.4008ZM26.433 24.4057H25.4057V24.0267L25.7299 23.7026L26.433 24.4057ZM45.5 24.4057H27.8472L26.437 22.9955L27.871 21.5614H45.5V24.4057ZM19.5862 22.9955L18.1759 24.4057H0.5V21.5614H18.1521L19.5862 22.9955Z" fill="white" stroke="white" />
                                    </svg>
                                    <?php echo esc_html($item['marquee_title']) ?>
                                </h4>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

        <?php else : ?>

            <div class="marquee__wrap">
                <div class="marquee__box">
                    <?php foreach ($settings['tg_marquee_list'] as $item) : ?>
                        <a data-hover='Marketing' href='<?php echo esc_url($item['marquee_url']) ?>'><?php echo esc_html($item['marquee_title']) ?></a>
                    <?php endforeach; ?>
                </div>
                <div class="marquee__box">
                    <?php foreach ($settings['tg_marquee_list'] as $item) : ?>
                        <a data-hover='Marketing' href='<?php echo esc_url($item['marquee_url']) ?>'><?php echo esc_html($item['marquee_title']) ?></a>
                    <?php endforeach; ?>
                </div>
            </div>

        <?php endif; ?>

<?php
    }
}

$widgets_manager->register(new TG_MARQUEE());
