<?php

namespace GenixCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Apexa Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TG_ServicesSidebar extends Widget_Base
{

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tg-services-sidebar';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Services Sidebar', 'genixcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'genix-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['genixcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['genixcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function register_controls()
    {

        // layout Panel
        $this->start_controls_section(
            'tg_layout',
            [
                'label' => esc_html__('Widget Layout', 'genixcore'),
            ]
        );

        $this->add_control(
            'tg_design_style',
            [
                'label' => esc_html__('Select Widget', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Services List', 'genixcore'),
                    'layout-2' => esc_html__('Brochure Download', 'genixcore'),
                    'layout-3' => esc_html__('Latest Services', 'genixcore'),
                    'layout-4' => esc_html__('Contact Number', 'genixcore'),
                    'layout-5' => esc_html__('Quote Form', 'genixcore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        // Widget Group
        $this->start_controls_section(
            '__tg_widget_group',
            [
                'label' => esc_html__('Widget Group', 'genixcore'),
            ]
        );

        $this->add_control(
            'post_design_style',
            [
                'label' => esc_html__('Select Post List Style', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style-1' => esc_html__('Style 01', 'genixcore'),
                    'style-2' => esc_html__('Style 02', 'genixcore'),
                    'style-3' => esc_html__('Style 03', 'genixcore'),
                    'style-4' => esc_html__('Style 04', 'genixcore'),
                ],
                'default' => 'style-1',
                'condition' => [
                    'tg_design_style' => 'layout-1'
                ]
            ]
        );

        $this->add_control(
            'brochure_design_style',
            [
                'label' => esc_html__('Select Brochure Style', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style-1' => esc_html__('Style 01', 'genixcore'),
                    'style-2' => esc_html__('Style 02', 'genixcore'),
                ],
                'default' => 'style-1',
                'condition' => [
                    'tg_design_style' => 'layout-2'
                ]
            ]
        );

        $this->add_control(
            'contact_design_style',
            [
                'label' => esc_html__('Select Contact Style', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style-1' => esc_html__('Style 01', 'genixcore'),
                    'style-2' => esc_html__('Style 02', 'genixcore'),
                ],
                'default' => 'style-1',
                'condition' => [
                    'tg_design_style' => 'layout-4'
                ]
            ]
        );

        $this->add_control(
            'widget_title',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('Title', 'genixcore'),
                'default' => esc_html__('Our Services', 'genixcore'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'tg_design_style!' => 'layout-1'
                ]
            ]
        );

        $this->add_control(
            'show_per_page',
            [
                'label' => esc_html__('Posts Per Page', 'genixcore'),
                'description' => esc_html__('Leave blank or enter -1 for all.', 'genixcore'),
                'type' => Controls_Manager::NUMBER,
                'default' => '6',
                'condition' => [
                    'tg_design_style' => 'layout-1'
                ]
            ]
        );

        $this->add_control(
            'show_post_page',
            [
                'label' => esc_html__('Posts Per Page', 'genixcore'),
                'description' => esc_html__('Leave blank or enter -1 for all.', 'genixcore'),
                'type' => Controls_Manager::NUMBER,
                'default' => '4',
                'condition' => [
                    'tg_design_style' => 'layout-3'
                ]
            ]
        );

        $this->add_control(
            'tg_description',
            [
                'label' => esc_html__('Description', 'genixcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('When an unknown printer took galley offer typey anddey.', 'genixcore'),
                'condition' => [
                    'tg_design_style' => 'layout-2'
                ]
            ]
        );

        $this->add_control(
            'widget_phone',
            [
                'label' => esc_html__('Phone Number', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('+91 705 2101 786', 'genixcore'),
                'condition' => [
                    'tg_design_style' => 'layout-4'
                ]
            ]
        );

        $this->add_control(
            'quote_shortcode',
            [
                'label' => __('Short Code', 'genixcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('[Add your short code]', 'genixcore'),
                'label_block' => true,
                'default' => __('', 'genixcore'),
                'condition' => [
                    'tg_design_style' => 'layout-5'
                ]
            ]
        );

        $this->add_control(
            'tg_image',
            [
                'label' => esc_html__('Choose Background', 'genixcore'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tg_design_style' => 'layout-4',
                    'contact_design_style' => 'style-2',
                ]
            ]
        );

        $this->end_controls_section();

        // Button Group
        $this->start_controls_section(
            '__tg_button_group',
            [
                'label' => esc_html__('Download Button', 'genixcore'),
                'condition' => [
                    'tg_design_style' => 'layout-2'
                ]
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'button_text',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('Button Text', 'genixcore'),
                'default' => esc_html__('PDF. Download', 'genixcore'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'download_url',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('Download File URL', 'genixcore'),
                'default' => esc_html__('#', 'genixcore'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'item_lists',
            [
                'label' => esc_html__('Button Lists', 'genixcore'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'button_text' => esc_html__('PDF. Download', 'genixcore'),
                    ],
                    [
                        'button_text' => esc_html__('DOC. Download', 'genixcore'),
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        // Style TAB
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', 'genixcore'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_transform',
            [
                'label' => esc_html__('Text Transform', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('None', 'genixcore'),
                    'uppercase' => esc_html__('UPPERCASE', 'genixcore'),
                    'lowercase' => esc_html__('lowercase', 'genixcore'),
                    'capitalize' => esc_html__('Capitalize', 'genixcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'text-transform: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

?>

        <?php if ($settings['tg_design_style']  == 'layout-2') : ?>

            <?php if ($settings['brochure_design_style'] == 'style-2') : ?>
                <div class="sidebar__widget sidebar__widget-three">
                    <?php if (!empty($settings['widget_title'])) : ?>
                        <h4 class="sidebar__widget-title"><?php echo esc_html($settings['widget_title']); ?></h4>
                    <?php endif; ?>
                    <div class="sidebar__brochure sidebar__brochure-two">
                        <?php if (!empty($settings['tg_description'])) : ?>
                            <p><?php echo genix_kses($settings['tg_description']); ?></p>
                        <?php endif; ?>
                        <?php foreach ($settings['item_lists'] as $item) : ?>
                            <a href="<?php echo esc_url($item['download_url']) ?>" target="_blank" download class="download-btn"><i class="far fa-file-pdf"></i><?php echo genix_kses($item['button_text']); ?></a>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php else : ?>
                <div class="sidebar__widget">
                    <?php if (!empty($settings['widget_title'])) : ?>
                        <h4 class="sidebar__widget-title"><?php echo esc_html($settings['widget_title']); ?></h4>
                    <?php endif; ?>
                    <div class="sidebar__brochure">
                        <?php if (!empty($settings['tg_description'])) : ?>
                            <p><?php echo genix_kses($settings['tg_description']); ?></p>
                        <?php endif; ?>

                        <?php foreach ($settings['item_lists'] as $item) : ?>
                            <a href="<?php echo esc_url($item['download_url']) ?>" target="_blank" download class="download-btn"><i class="far fa-file-pdf"></i><?php echo genix_kses($item['button_text']); ?></a>
                        <?php endforeach; ?>
                    </div>
                </div>

            <?php endif; ?>

        <?php elseif ($settings['tg_design_style']  == 'layout-3') : ?>

            <div class="sidebar__widget">
                <?php if (!empty($settings['widget_title'])) : ?>
                    <h4 class="sidebar__widget-title"><?php echo esc_html($settings['widget_title']); ?></h4>
                <?php endif; ?>
                <div class="sidebar__post-list">
                    <?php
                    $args = new \WP_Query(array(
                        'post_type' => 'services',
                        'post_status' => 'publish',
                        'orderby' => 'date',
                        'posts_per_page' => $settings['show_post_page'],
                    ));

                    /* Start the Loop */
                    while ($args->have_posts()) : $args->the_post();
                    ?>
                        <div class="sidebar__post-item">
                            <?php if (has_post_thumbnail()) : ?>
                                <div class="sidebar__post-thumb">
                                    <a href="<?php the_permalink(); ?>">
                                        <img src="<?php print esc_url(get_the_post_thumbnail_url(get_the_ID(), 'full')); ?>" alt="<?php echo esc_attr__('Image', 'genixcore') ?>">
                                    </a>
                                </div>
                            <?php endif; ?>
                            <div class="sidebar__post-content">
                                <h5 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                                <span class="date"><i class="flaticon-time"></i><?php the_time(get_option('date_format')); ?></span>
                            </div>
                        </div>
                    <?php endwhile;
                    wp_reset_postdata(); ?>
                </div>
            </div>

        <?php elseif ($settings['tg_design_style']  == 'layout-4') : ?>

            <?php if ($settings['contact_design_style'] == 'style-2') : ?>
                <div class="sidebar__widget sidebar__widget-two">
                    <div class="sidebar__contact sidebar__contact-two" style="background-image: url(<?php echo esc_url($settings['tg_image']['url']) ?>);">
                        <?php if (!empty($settings['widget_title'])) : ?>
                            <h2 class="title"><?php echo esc_html($settings['widget_title']); ?></h2>
                        <?php endif; ?>
                        <a href="tel:<?php echo esc_attr($settings['widget_phone']); ?>" class="btn"><i class="flaticon-phone-call"></i><?php echo esc_html($settings['widget_phone']); ?></a>
                    </div>
                </div>
            <?php else : ?>
                <div class="sidebar__contact">
                    <?php if (!empty($settings['widget_title'])) : ?>
                        <h2 class="title"><?php echo esc_html($settings['widget_title']); ?></h2>
                    <?php endif; ?>
                    <a href="tel:<?php echo esc_attr($settings['widget_phone']); ?>" class="btn"><i class="flaticon-phone-call"></i><?php echo esc_html($settings['widget_phone']); ?></a>
                </div>
            <?php endif; ?>

        <?php elseif ($settings['tg_design_style']  == 'layout-5') : ?>

            <div class="sidebar__widget sidebar__widget-three">
                <?php if (!empty($settings['widget_title'])) : ?>
                    <h4 class="sidebar__widget-title"><?php echo esc_html($settings['widget_title']); ?></h4>
                <?php endif; ?>
                <?php echo do_shortcode($settings['quote_shortcode']); ?>
            </div>

        <?php else : ?>

            <?php if ($settings['post_design_style'] == 'style-2') : ?>
                <div class="sidebar__widget sidebar__widget-three">
                    <div class="sidebar__cat-list-two sidebar__cat-list-three">
                        <ul class="list-wrap">
                            <?php
                            $args = new \WP_Query(array(
                                'post_type' => 'services',
                                'post_status' => 'publish',
                                'orderby' => 'date',
                                'posts_per_page' => $settings['show_per_page'],
                            ));

                            /* Start the Loop */
                            while ($args->have_posts()) : $args->the_post();
                            ?>
                                <li>
                                    <a href="<?php the_permalink(); ?>">
                                        <span><?php the_title(); ?></span>
                                        <i class="flaticon-arrow-button"></i>
                                    </a>
                                </li>
                            <?php endwhile;
                            wp_reset_postdata(); ?>
                        </ul>
                    </div>
                </div>
            <?php elseif ($settings['post_design_style'] == 'style-3') : ?>
                <div class="sidebar__widget">
                    <div class="sidebar__cat-list-two sidebar__cat-list-three">
                        <ul class="list-wrap">
                            <?php
                            $args = new \WP_Query(array(
                                'post_type' => 'services',
                                'post_status' => 'publish',
                                'orderby' => 'date',
                                'posts_per_page' => $settings['show_per_page'],
                            ));

                            /* Start the Loop */
                            while ($args->have_posts()) : $args->the_post();
                            ?>
                                <li>
                                    <a href="<?php the_permalink(); ?>">
                                        <span><?php the_title(); ?></span>
                                        <i class="flaticon-arrow-button"></i>
                                    </a>
                                </li>
                            <?php endwhile;
                            wp_reset_postdata(); ?>
                        </ul>
                    </div>
                </div>
            <?php elseif ($settings['post_design_style'] == 'style-4') : ?>
                <div class="sidebar__widget">
                    <div class="sidebar__cat-list-two">
                        <ul class="list-wrap">
                            <?php
                            $args = new \WP_Query(array(
                                'post_type' => 'services',
                                'post_status' => 'publish',
                                'orderby' => 'date',
                                'posts_per_page' => $settings['show_per_page'],
                            ));

                            /* Start the Loop */
                            while ($args->have_posts()) : $args->the_post();
                            ?>
                                <li>
                                    <a href="<?php the_permalink(); ?>">
                                        <span><?php the_title(); ?></span>
                                        <i class="flaticon-arrow-button"></i>
                                    </a>
                                </li>
                            <?php endwhile;
                            wp_reset_postdata(); ?>
                        </ul>
                    </div>
                </div>
            <?php else : ?>
                <div class="sidebar__widget sidebar__widget-two">
                    <div class="sidebar__cat-list-two">
                        <ul class="list-wrap">
                            <?php
                            $args = new \WP_Query(array(
                                'post_type' => 'services',
                                'post_status' => 'publish',
                                'orderby' => 'date',
                                'posts_per_page' => $settings['show_per_page'],
                            ));

                            /* Start the Loop */
                            while ($args->have_posts()) : $args->the_post();
                            ?>
                                <li>
                                    <a href="<?php the_permalink(); ?>">
                                        <span><?php the_title(); ?></span>
                                        <i class="flaticon-arrow-button"></i>
                                    </a>
                                </li>
                            <?php endwhile;
                            wp_reset_postdata(); ?>
                        </ul>
                    </div>
                </div>
            <?php endif; ?>

        <?php endif; ?>

<?php
    }
}

$widgets_manager->register(new TG_ServicesSidebar());
