<?php

namespace GenixCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Apexa Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TG_Btn extends Widget_Base
{

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tg-btn';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Apexa Button', 'genixcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'genix-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['genixcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['genixcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function register_controls()
    {

        // layout Panel
        $this->start_controls_section(
            'genix_layout',
            [
                'label' => esc_html__('Design Layout', 'genixcore'),
            ]
        );
        $this->add_control(
            'tg_design_style',
            [
                'label' => esc_html__('Select Layout', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Default Button', 'genixcore'),
                    'layout-2' => esc_html__('Border Button', 'genixcore'),
                    'layout-3' => esc_html__('Target Button', 'genixcore'),
                    'layout-4' => esc_html__('Video Button', 'genixcore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        // tg_button_group
        $this->start_controls_section(
            'tg_button_group',
            [
                'label' => esc_html__('Button', 'genixcore'),
                'condition' => [
                    'tg_design_style!' => ['layout-3', 'layout-4']
                ]
            ]
        );

        $this->add_control(
            'tg_button_show',
            [
                'label' => esc_html__('Show Button', 'genixcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'genixcore'),
                'label_off' => esc_html__('Hide', 'genixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'tg_btn_text',
            [
                'label' => esc_html__('Button Text', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Button Text', 'genixcore'),
                'title' => esc_html__('Enter button text', 'genixcore'),
                'label_block' => true,
                'condition' => [
                    'tg_button_show' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'tg_btn_link_type',
            [
                'label' => esc_html__('Button Link Type', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'label_block' => true,
                'condition' => [
                    'tg_button_show' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'tg_btn_link',
            [
                'label' => esc_html__('Button link', 'genixcore'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('https://your-link.com', 'genixcore'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'condition' => [
                    'tg_btn_link_type' => '1',
                    'tg_button_show' => 'yes'
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'tg_btn_page_link',
            [
                'label' => esc_html__('Select Button Page', 'genixcore'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => genix_get_all_pages(),
                'condition' => [
                    'tg_btn_link_type' => '2',
                    'tg_button_show' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'tg_align',
            [
                'label' => esc_html__('Alignment', 'genixcore'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'genixcore'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'genixcore'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'genixcore'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => false,
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();

        // _target_button
        $this->start_controls_section(
            '_tg_target_section',
            [
                'label' => esc_html__('Target Button', 'genixcore'),
                'condition' => [
                    'tg_design_style' => 'layout-3'
                ]
            ]
        );

        $this->add_control(
            'target_btn_text',
            [
                'label' => esc_html__('Button Text', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Scroll Down', 'genixcore'),
                'title' => esc_html__('Enter button text', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'target_url',
            [
                'label' => esc_html__('Target Section ID', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#about', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        // _tg_video
        $this->start_controls_section(
            '_tg_video_section',
            [
                'label' => esc_html__('Video Button', 'genixcore'),
                'condition' => [
                    'tg_design_style' => 'layout-4'
                ]
            ]
        );

        $this->add_control(
            'video_url',
            [
                'label' => esc_html__('Video URL', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('https://www.youtube.com/watch?v=6mkoGSqTqFI', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', 'genixcore'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'tg_design_style!' => 'layout-3',
                ]
            ]
        );

        $this->add_control(
            'text_transform',
            [
                'label' => esc_html__('Text Transform', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('None', 'genixcore'),
                    'uppercase' => esc_html__('UPPERCASE', 'genixcore'),
                    'lowercase' => esc_html__('lowercase', 'genixcore'),
                    'capitalize' => esc_html__('Capitalize', 'genixcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .btn' => 'text-transform: {{VALUE}};',
                ],
                'condition' => [
                    'tg_design_style!' => 'layout-4',
                ]
            ]
        );

        $this->add_control(
            '_border_gap',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__('Button Style', 'genixcore'),
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'button_icon',
            [
                'label' => esc_html__('Button Icon', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'default' => 'block',
                'options' => [
                    'none' => esc_html__('No', 'genixcore'),
                    'block' => esc_html__('Yes', 'genixcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .btn::after' => 'display: {{VALUE}};',
                ],
                'condition' => [
                    'tg_design_style!' => 'layout-4',
                ]
            ]
        );

        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => esc_html__('Button Padding', 'genixcore'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'tg_design_style!' => 'layout-4',
                ]
            ]
        );

        $this->add_responsive_control(
            'video_btn_width',
            [
                'label' => esc_html__('Video Button Width', 'genixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .tg-play-btn' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'tg_design_style' => 'layout-4',
                ]
            ]
        );

        $this->add_responsive_control(
            'video_btn_height',
            [
                'label' => esc_html__('Video Button Height', 'genixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .tg-play-btn' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'tg_design_style' => 'layout-4',
                ]
            ]
        );

        $this->add_responsive_control(
            'video_btn_size',
            [
                'label' => esc_html__('Video Icon Size', 'genixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .tg-play-btn' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'tg_design_style' => 'layout-4',
                ]
            ]
        );

        $this->start_controls_tabs(
            '_tab_style_button_box'
        );
        $this->start_controls_tab(
            '_tab_normal_button',
            [
                'label' => esc_html__('Normal', 'genixcore'),
            ]
        );

        $this->add_control(
            '_default_btn_color',
            [
                'label' => esc_html__('Text Color', 'genixcore'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .tg-play-btn' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            '_default_btn_bg',
            [
                'label' => esc_html__('Background', 'genixcore'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn' => 'background: {{VALUE}}',
                    '{{WRAPPER}} .tg-play-btn' => 'background: {{VALUE}}',
                ],
                'condition' => [
                    'tg_design_style' => ['layout-1', 'layout-4']
                ]
            ]
        );

        $this->add_control(
            '_border_btn_color',
            [
                'label' => esc_html__('Border Color', 'genixcore'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .border-btn' => 'border-color: {{VALUE}}',
                ],
                'condition' => [
                    'tg_design_style' => 'layout-2'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_hover_button',
            [
                'label' => esc_html__('Hover', 'genixcore'),
            ]
        );

        $this->add_control(
            '_default_btn_hover_color',
            [
                'label' => esc_html__('Text Color', 'genixcore'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .tg-play-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            '_default_btn_hover_bg',
            [
                'label' => esc_html__('Background', 'genixcore'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn:hover::before' => 'background: {{VALUE}}',
                ],
                'condition' => [
                    'tg_design_style' => 'layout-1'
                ]
            ]
        );

        $this->add_control(
            '_border_btn_hover',
            [
                'label' => esc_html__('Border Color', 'genixcore'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .border-btn:hover' => 'border-color: {{VALUE}}',
                ],
                'condition' => [
                    'tg_design_style' => 'layout-2'
                ]
            ]
        );

        $this->add_control(
            '_border_btn_bg',
            [
                'label' => esc_html__('Background', 'genixcore'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .border-btn:hover' => 'background: {{VALUE}}',
                    '{{WRAPPER}} .tg-play-btn:hover' => 'background: {{VALUE}}',
                ],
                'condition' => [
                    'tg_design_style' => ['layout-2', 'layout-4']
                ]
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display(); ?>


        <?php if ($settings['tg_design_style'] == 'layout-2') :
            // Link
            if ('2' == $settings['tg_btn_link_type']) {
                $this->add_render_attribute('tg-button-arg', 'href', get_permalink($settings['tg_btn_page_link']));
                $this->add_render_attribute('tg-button-arg', 'target', '_self');
                $this->add_render_attribute('tg-button-arg', 'rel', 'nofollow');
                $this->add_render_attribute('tg-button-arg', 'class', 'btn border-btn');
            } else {
                if (!empty($settings['tg_btn_link']['url'])) {
                    $this->add_link_attributes('tg-button-arg', $settings['tg_btn_link']);
                    $this->add_render_attribute('tg-button-arg', 'class', 'btn border-btn');
                }
            }
        ?>

            <?php if (!empty($settings['tg_button_show'])) : ?>
                <a <?php echo $this->get_render_attribute_string('tg-button-arg'); ?>>
                    <?php echo $settings['tg_btn_text']; ?>
                </a>
            <?php endif; ?>


        <?php elseif ($settings['tg_design_style'] == 'layout-3') : ?>

            <div class="banner-scroll">
                <a href="<?php echo esc_attr($settings['target_url']) ?>"><?php echo esc_html($settings['target_btn_text']) ?> <span><i class="fas fa-arrow-right"></i></span></a>
            </div>


        <?php elseif ($settings['tg_design_style'] == 'layout-4') : ?>

            <a href="<?php echo esc_url($settings['video_url']) ?>" class="tg-play-btn play-btn popup-video">
                <i class="fas fa-play"></i>
            </a>

        <?php else :
            // Link
            if ('2' == $settings['tg_btn_link_type']) {
                $this->add_render_attribute('tg-button-arg', 'href', get_permalink($settings['tg_btn_page_link']));
                $this->add_render_attribute('tg-button-arg', 'target', '_self');
                $this->add_render_attribute('tg-button-arg', 'rel', 'nofollow');
                $this->add_render_attribute('tg-button-arg', 'class', 'btn');
            } else {
                if (!empty($settings['tg_btn_link']['url'])) {
                    $this->add_link_attributes('tg-button-arg', $settings['tg_btn_link']);
                    $this->add_render_attribute('tg-button-arg', 'class', 'btn');
                }
            }
        ?>

            <?php if (!empty($settings['tg_button_show'])) : ?>
                <a <?php echo $this->get_render_attribute_string('tg-button-arg'); ?>>
                    <?php echo $settings['tg_btn_text']; ?>
                </a>
            <?php endif; ?>

        <?php endif; ?>

<?php
    }
}

$widgets_manager->register(new TG_Btn());
