<?php

namespace GenixCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Apexa Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TG_CTA extends Widget_Base
{

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tg-cta';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('CTA', 'genixcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'genix-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['genixcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['genixcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function register_controls()
    {

        // layout Panel
        $this->start_controls_section(
            'genix_layout',
            [
                'label' => esc_html__('Design Layout', 'genixcore'),
            ]
        );
        $this->add_control(
            'genix_design_style',
            [
                'label' => esc_html__('Select Layout', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'genixcore'),
                    'layout-2' => esc_html__('Layout 2', 'genixcore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        // _tg_year
        $this->start_controls_section(
            '_tg_year_text',
            [
                'label' => esc_html__('Experience', 'genixcore'),
                'condition' => [
                    'genix_design_style' => 'layout-1',
                ]
            ]
        );

        $this->add_control(
            'tg_exp_year',
            [
                'label' => esc_html__('Exp Year', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('40+', 'genixcore'),
                'placeholder' => esc_html__('Type Text Here', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tg_exp_text',
            [
                'label' => esc_html__('Exp Text', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Consulting farm', 'genixcore'),
                'placeholder' => esc_html__('Type Text Here', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        // _tg_title
        $this->start_controls_section(
            '_tg_title_text',
            [
                'label' => esc_html__('Title & Content', 'genixcore'),
                'condition' => [
                    'genix_design_style' => 'layout-1',
                ]
            ]
        );

        $this->add_control(
            'tg_title',
            [
                'label' => esc_html__('Title', 'genixcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Trusted , Happy & Satisfied Businesses', 'genixcore'),
                'placeholder' => esc_html__('Type Text Here', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tg_desc',
            [
                'label' => esc_html__('Description', 'genixcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('When you work with HR Solutions, you get the best. We provide adaptable solutions that allow you to be a part of the entire process', 'genixcore'),
                'placeholder' => esc_html__('Type Text Here', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        // _tg_number
        $this->start_controls_section(
            '_tg_contact_text',
            [
                'label' => esc_html__('Phone and Content', 'genixcore'),
                'condition' => [
                    'genix_design_style' => 'layout-2',
                ]
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'help_img',
            [
                'label' => esc_html__('Choose Image', 'genixcore'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'tg_help_text',
            [
                'label' => esc_html__('Title', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Need help? Call us', 'genixcore'),
                'placeholder' => esc_html__('Type Text Here', 'genixcore'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tg_help_phone',
            [
                'label' => esc_html__('Phone', 'genixcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('1-800-222-8888', 'genixcore'),
                'placeholder' => esc_html__('Type Text Here', 'genixcore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tg_list',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tg_help_text' => esc_html__('Need help? Call us', 'genixcore'),
                        'tg_help_phone' => esc_html__('1-800-222-8888', 'genixcore'),
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        // _tg_image
        $this->start_controls_section(
            '_tg_img_shape',
            [
                'label' => esc_html__('Image & Shape', 'genixcore'),
                'condition' => [
                    'genix_design_style' => 'layout-1',
                ]
            ]
        );

        $this->add_control(
            'cta_img',
            [
                'label' => esc_html__('Choose Image', 'genixcore'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'cta_shape',
            [
                'label' => esc_html__('Choose Shape', 'genixcore'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', 'genixcore'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label' => esc_html__('Content Padding', 'genixcore'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .consulting-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'genix_design_style' => 'layout-1',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_background',
                'selector' => '{{WRAPPER}} .consulting-content',
                'exclude' => [
                    'image'
                ],
                'condition' => [
                    'genix_design_style' => 'layout-1',
                ]
            ]
        );

        $this->add_control(
            'text_transform',
            [
                'label' => esc_html__('Text Transform', 'genixcore'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('None', 'genixcore'),
                    'uppercase' => esc_html__('UPPERCASE', 'genixcore'),
                    'lowercase' => esc_html__('lowercase', 'genixcore'),
                    'capitalize' => esc_html__('Capitalize', 'genixcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'text-transform: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>

        <?php if ($settings['genix_design_style'] === 'layout-2') : ?>

            <script>
                jQuery(document).ready(function($) {
                    var swiper3 = new Swiper(".slider_baner__active", {
                        spaceBetween: 0,
                        // effect: "fade",
                        loop: true,
                        autoplay: {
                            delay: 6000,
                        },
                        // Navigation arrows
                        navigation: {
                            nextEl: '.button-swiper-next',
                            prevEl: '.button-swiper-prev',
                        },
                        pagination: {
                            el: '.swiper-pagination-testimonials',
                            clickable: true
                        },
                    });
                });
            </script>

            <div class="swiper-container slider_baner__active slider_baner_home6">
                <div class="swiper-wrapper">
                    <?php foreach ($settings['tg_list'] as $item) : ?>
                        <div class="swiper-slide slide__home7">
                            <img src="<?php echo esc_url($item['help_img']['url']); ?>" alt="<?php echo esc_attr__('Image', 'genixcore') ?>">
                            <div class="box-info-contact">
                                <p class="text-need-help">
                                    <svg width="38" height="38" viewBox="0 0 38 38" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_66_3059)">
                                            <path d="M18.9062 2.21558C22.7573 2.21713 26.4894 3.54999 29.4702 5.98832C32.451 8.42666 34.4972 11.8205 35.262 15.5948C36.0269 19.3692 35.4634 23.2919 33.667 26.6983C31.8707 30.1047 28.9519 32.7854 25.4053 34.286C21.3263 36.0097 16.7297 36.0424 12.6266 34.3769C8.52353 32.7114 5.25011 29.4842 3.52646 25.4053C1.80281 21.3263 1.77013 16.7297 3.43559 12.6266C5.10106 8.52353 8.32825 5.25011 12.4072 3.52646C14.4632 2.6564 16.6737 2.21053 18.9062 2.21558ZM18.9062 0C8.46498 0 0 8.46498 0 18.9062C0 29.3475 8.46498 37.8125 18.9062 37.8125C29.3475 37.8125 37.8125 29.3475 37.8125 18.9062C37.8125 8.46498 29.3475 0 18.9062 0Z" fill="white" />
                                            <path d="M24.422 29.088C23.3238 29.0142 21.7759 28.6353 20.2648 28.0947C14.9371 26.1878 9.73864 21.1075 8.63381 14.0014C8.43736 12.7363 8.64415 11.5806 9.60275 10.6397C9.92401 10.3251 10.2098 9.975 10.5237 9.653C11.7053 8.43665 13.432 8.40563 14.6557 9.57398C15.0435 9.94324 15.4378 10.3073 15.816 10.6884C16.3337 11.199 16.6335 11.8904 16.6524 12.6174C16.6713 13.3443 16.4077 14.0503 15.9171 14.5871C15.6217 14.915 15.3116 15.2266 14.9999 15.5376C14.6594 15.8773 14.2363 16.0723 13.7821 16.2141C13.2215 16.3898 13.1174 16.6247 13.3722 17.1601C14.9822 20.5322 17.5023 22.9602 20.9325 24.4442C21.3911 24.6421 21.6031 24.5527 21.7877 24.0978C22.1924 23.1001 22.9346 22.3726 23.7876 21.7848C24.7529 21.1201 26.1354 21.2678 27.0497 22.0536C27.5509 22.4843 28.0299 22.9403 28.4846 23.4198C28.974 23.9434 29.2458 24.6334 29.2452 25.35C29.2445 26.0666 28.9713 26.7561 28.4809 27.2786C28.3384 27.4337 28.1914 27.5851 28.0548 27.7447C27.2321 28.701 26.1886 29.1486 24.422 29.088Z" fill="white" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_66_3059">
                                                <rect width="37.8125" height="37.8125" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                    <?php echo genix_kses($item['tg_help_text']); ?>
                                </p>
                                <p class="text-42-bold text-phone"><?php echo genix_kses($item['tg_help_phone']); ?></p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="box-button-slider-bottom">
                <div class="testimonial__nav-four">
                    <div class="testimonial-two-button-prev button-swiper-prev">
                        <i class="flaticon-right-arrow"></i>
                    </div>
                    <div class="testimonial-two-button-next button-swiper-next">
                        <i class="flaticon-right-arrow"></i>
                    </div>
                </div>
            </div>

        <?php else : ?>

            <div class="consulting-inner-wrap shine-animate-item">
                <div class="consulting-content">
                    <div class="content-left">
                        <?php if (!empty($settings['tg_exp_year'])) : ?>
                            <h2 class="title"><?php echo $settings['tg_exp_year']; ?></h2>
                        <?php endif; ?>
                        <?php if (!empty($settings['tg_exp_text'])) : ?>
                            <span><?php echo $settings['tg_exp_text']; ?></span>
                        <?php endif; ?>
                    </div>
                    <div class="content-right">
                        <?php if (!empty($settings['tg_title'])) : ?>
                            <h2 class="title"><?php echo $settings['tg_title']; ?></h2>
                        <?php endif; ?>
                        <?php if (!empty($settings['tg_desc'])) : ?>
                            <p><?php echo $settings['tg_desc']; ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if (!empty($settings['cta_img']['url'])) : ?>
                    <div class="consulting-img shine-animate">
                        <img src="<?php echo esc_url($settings['cta_img']['url']); ?>" alt="<?php echo esc_attr__('Image', 'genixcore') ?>">
                    </div>
                <?php endif; ?>
                <?php if (!empty($settings['cta_shape']['url'])) : ?>
                    <div class="consulting-shape">
                        <img src="<?php echo esc_url($settings['cta_shape']['url']); ?>" alt="<?php echo esc_attr__('Image', 'genixcore') ?>">
                    </div>
                <?php endif; ?>
            </div>

        <?php endif; ?>
<?php
    }
}

$widgets_manager->register(new TG_CTA());
