<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package apexa
 */
?>

<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <?php if (is_singular() && pings_open(get_queried_object())) : ?>
    <?php endif; ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

    <?php wp_body_open(); ?>


    <?php
        $apexa_preloader = get_theme_mod('apexa_preloader', false);
        $apexa_preloader_logo = get_template_directory_uri() . '/assets/img/logo/preloader.png';

        $preloader_logo = get_theme_mod('preloader_logo', $apexa_preloader_logo);

        $apexa_backtotop = get_theme_mod('apexa_backtotop', false);
    ?>


    <?php if (!empty($apexa_preloader)) : ?>
        <!-- preloader -->
        <div id="preloader">
            <div id="loader" class="loader">
                <div class="loader-container">
                    <div class="loader-icon"><img src="<?php echo esc_url( $preloader_logo ) ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>"></div>
                </div>
            </div>
        </div>
        <!-- preloader-end -->
    <?php endif; ?>


    <?php if (!empty($apexa_backtotop)) : ?>
        <!-- Scroll-top -->
        <button class="scroll__top scroll-to-target" data-target="html">
            <i class="fas fa-angle-up"></i>
        </button>
        <!-- Scroll-top-end-->
    <?php endif; ?>


    <?php do_action('apexa_header_style'); ?>

    <!-- main-area -->
    <main class="main-area fix">

        <?php do_action('apexa_before_main_content'); ?>