<?php
/**
 * apexa customizer
 *
 * @package apexa
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Added Panels & Sections
 */
function apexa_customizer_panels_sections( $wp_customize ) {

    //Add panel
    $wp_customize->add_panel( 'apexa_customizer', [
        'priority' => 10,
        'title'    => esc_html__( 'Apexa Customizer', 'apexa' ),
    ] );

    /**
     * Customizer Section
     */
    $wp_customize->add_section( 'apexa_default_setting', [
        'title'       => esc_html__( 'Apexa Default Setting', 'apexa' ),
        'description' => '',
        'priority'    => 10,
        'capability'  => 'edit_theme_options',
        'panel'       => 'apexa_customizer',
    ] );

    $wp_customize->add_section('section_header_logo', [
        'title'       => esc_html__('Header Setting', 'apexa'),
        'description' => '',
        'priority'    => 11,
        'capability'  => 'edit_theme_options',
        'panel'       => 'apexa_customizer',
    ]);

    $wp_customize->add_section( 'header_top_setting', [
        'title'       => esc_html__( 'Header Top Setting', 'apexa' ),
        'description' => '',
        'priority'    => 12,
        'capability'  => 'edit_theme_options',
        'panel'       => 'apexa_customizer',
    ] );

    $wp_customize->add_section( 'header_info_setting', [
        'title'       => esc_html__( 'Header Info Setting', 'apexa' ),
        'description' => '',
        'priority'    => 13,
        'capability'  => 'edit_theme_options',
        'panel'       => 'apexa_customizer',
    ] );

    $wp_customize->add_section( 'offcanvas_setting', [
        'title'       => esc_html__( 'Offcanvas Setting', 'apexa' ),
        'description' => '',
        'priority'    => 14,
        'capability'  => 'edit_theme_options',
        'panel'       => 'apexa_customizer',
    ] );

    $wp_customize->add_section( 'mobile_menu_setting', [
        'title'       => esc_html__( 'Mobile Menu Setting', 'apexa' ),
        'description' => '',
        'priority'    => 15,
        'capability'  => 'edit_theme_options',
        'panel'       => 'apexa_customizer',
    ] );

    $wp_customize->add_section( 'breadcrumb_setting', [
        'title'       => esc_html__( 'Breadcrumb Setting', 'apexa' ),
        'description' => '',
        'priority'    => 16,
        'capability'  => 'edit_theme_options',
        'panel'       => 'apexa_customizer',
    ] );

    $wp_customize->add_section( 'blog_setting', [
        'title'       => esc_html__( 'Blog Setting', 'apexa' ),
        'description' => '',
        'priority'    => 17,
        'capability'  => 'edit_theme_options',
        'panel'       => 'apexa_customizer',
    ] );

    $wp_customize->add_section( 'footer_setting', [
        'title'       => esc_html__( 'Footer Settings', 'apexa' ),
        'description' => '',
        'priority'    => 18,
        'capability'  => 'edit_theme_options',
        'panel'       => 'apexa_customizer',
    ] );

    $wp_customize->add_section( 'color_setting', [
        'title'       => esc_html__( 'Color Setting', 'apexa' ),
        'description' => '',
        'priority'    => 19,
        'capability'  => 'edit_theme_options',
        'panel'       => 'apexa_customizer',
    ] );

    $wp_customize->add_section( '404_page', [
        'title'       => esc_html__( '404 Page', 'apexa' ),
        'description' => '',
        'priority'    => 20,
        'capability'  => 'edit_theme_options',
        'panel'       => 'apexa_customizer',
    ] );

    $wp_customize->add_section( 'typo_setting', [
        'title'       => esc_html__( 'Typography Setting', 'apexa' ),
        'description' => '',
        'priority'    => 21,
        'capability'  => 'edit_theme_options',
        'panel'       => 'apexa_customizer',
    ] );

    $wp_customize->add_section('slug_setting', [
        'title'       => esc_html__('Slug Settings', 'apexa'),
        'description' => '',
        'priority'    => 22,
        'capability'  => 'edit_theme_options',
        'panel'       => 'apexa_customizer',
    ]);

}

add_action( 'customize_register', 'apexa_customizer_panels_sections' );


/*
Theme Default Settings
*/
function _apexa_default_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_preloader',
        'label'    => esc_html__( 'Preloader ON/OFF', 'apexa' ),
        'section'  => 'apexa_default_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'apexa' ),
            'off' => esc_html__( 'Disable', 'apexa' ),
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'preloader_logo',
        'label'       => esc_html__('Preloader Logo', 'apexa'),
        'description' => esc_html__('Upload Preloader Logo.', 'apexa'),
        'section'     => 'apexa_default_setting',
        'default'     => get_template_directory_uri() . '/assets/img/logo/preloader.png',
        'active_callback'  => [
            [
                'setting'  => 'apexa_preloader',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_backtotop',
        'label'    => esc_html__( 'Back to Top ON/OFF', 'apexa' ),
        'section'  => 'apexa_default_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'apexa' ),
            'off' => esc_html__( 'Disable', 'apexa' ),
        ],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_apexa_default_fields' );


/*
Header Settings
 */
function _header_header_fields( $fields ) {

    // Sticky Header
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_show_sticky_header',
        'label'    => esc_html__( 'Show Sticky Header', 'apexa' ),
        'section'  => 'section_header_logo',
        'default'  => 0,
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'apexa' ),
            'off' => esc_html__( 'Disable', 'apexa' ),
        ],
        'active_callback' => [
            [
                'setting' => 'apexa_header_elementor_switch',
                'operator' => '==',
                'value' => false
            ]
        ]
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_header_elementor_switch',
        'label'       => esc_html__('Elementor Header Switch', 'apexa'),
        'section'  => 'section_header_logo',
        'default'  => 0,
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'apexa'),
            'off' => esc_html__('Disable', 'apexa'),
        ],
    ];

    $fields[] = [
        'type'        => 'radio-image',
        'settings'    => 'choose_default_header',
        'label'       => esc_html__( 'Select Header Style', 'apexa' ),
        'section'     => 'section_header_logo',
        'description' => esc_html__( 'If you select a Header Style from the edit page, This option will not work. So go to edit page then change the header style.', 'apexa' ),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            'header-style-1' => get_template_directory_uri() . '/inc/img/header/header-1.png',
        ],
        'default'     => 'header-style-1',
        'active_callback' => [
            [
                'setting' => 'apexa_header_elementor_switch',
                'operator' => '==',
                'value' => false
            ]
        ]
    ];

    $header_posttype = array(
        'post_type'      => 'apexa-header',
        'posts_per_page' => -1,
    );
    $header_posttype_loop = get_posts($header_posttype);

    $header_post_obj_arr = array();
    foreach ($header_posttype_loop as $post) {
        $header_post_obj_arr[$post->ID] = $post->post_title;
    }

    wp_reset_query();

    $fields[] = [
        'type'     => 'select',
        'settings' => 'apexa_header_templates',
        'label'       => esc_html__('Elementor Header Template', 'apexa'),
        'section'  => 'section_header_logo',
        'description' => esc_html__('If you select a Header Style from the edit page, This option will not work. So go to edit page then change the header style.', 'apexa'),
        'priority' => 10,
        'placeholder' => esc_html__('Choose an option', 'apexa'),
        'choices'     => $header_post_obj_arr,
        'active_callback' => [
            [
                'setting' => 'apexa_header_elementor_switch',
                'operator' => '==',
                'value' => true
            ]
        ]
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'logo',
        'label'       => esc_html__( 'Header Logo', 'apexa' ),
        'description' => esc_html__( 'Upload Your Logo', 'apexa' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo.png',
        'active_callback' => [
            [
                'setting' => 'apexa_header_elementor_switch',
                'operator' => '==',
                'value' => false
            ]
        ]
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'secondary_logo',
        'label'       => esc_html__( 'Header Secondary Logo', 'apexa' ),
        'description' => esc_html__( 'Upload Your Logo', 'apexa' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/secondary_logo.png',
        'active_callback' => [
            [
                'setting' => 'apexa_header_elementor_switch',
                'operator' => '==',
                'value' => false
            ]
        ]
    ];

    $fields[] = [
        'type'        => 'dimension',
        'settings'    => 'logo_size_adjust',
		'label'       => esc_html__( 'Logo Size Height', 'apexa' ),
		'description' => esc_html__( 'Adjust your logo size with px', 'apexa' ),
		'section'     => 'section_header_logo',
		'default'     => '34px',
        'choices'     => [
			'accept_unitless' => true,
		],
        'active_callback' => [
            [
                'setting' => 'apexa_header_elementor_switch',
                'operator' => '==',
                'value' => false
            ]
        ]
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_header_fields' );


/*
Header Top Settings
*/
function _header_top_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_show_header_top',
        'label'    => esc_html__('Show Header Top', 'apexa'),
        'section'  => 'header_top_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'apexa'),
            'off' => esc_html__('Disable', 'apexa'),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_header_phone_text',
        'label'    => esc_html__('Enter Phone Number', 'apexa'),
        'section'  => 'header_top_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('+123 9898 500', 'apexa'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_header_location',
        'label'    => esc_html__('Enter Location Text', 'apexa'),
        'section'  => 'header_top_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('256 Avenue, Mark Street, Newyork City', 'apexa'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_header_email_text',
        'label'    => esc_html__('Enter Email Address', 'apexa'),
        'section'  => 'header_top_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('info@apexa.com', 'apexa'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_header_date',
        'label'    => esc_html__('Enter Office Date', 'apexa'),
        'section'  => 'header_top_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_header_top',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('Mon-Fri: 10:00am - 09:00pm', 'apexa'),
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_top_fields' );


/*
Header Right Settings
*/
function _header_right_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_show_header_search',
        'label'    => esc_html__('Show Header Search', 'apexa'),
        'section'  => 'header_info_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'apexa'),
            'off' => esc_html__('Disable', 'apexa'),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_show_header_button',
        'label'    => esc_html__('Show Header Button', 'apexa'),
        'section'  => 'header_info_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'apexa'),
            'off' => esc_html__('Disable', 'apexa'),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_header_btn_text',
        'label'    => esc_html__('Enter Button Text', 'apexa'),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_header_button',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('let’s Talk', 'apexa'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_header_btn_url',
        'label'    => esc_html__('Enter Button URL', 'apexa'),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_header_button',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'apexa'),
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_show_header_button02',
        'label'    => esc_html__('Show Header Button 02', 'apexa'),
        'description' => esc_html__('This button showing on Header Style 06', 'apexa'),
        'section'  => 'header_info_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'apexa'),
            'off' => esc_html__('Disable', 'apexa'),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_header_btn_text02',
        'label'    => esc_html__('Enter Button Text 02', 'apexa'),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_header_button02',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('Free Trial', 'apexa'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_header_btn_url02',
        'label'    => esc_html__('Enter Button URL 02', 'apexa'),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_header_button02',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'apexa'),
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_right_fields' );


/*
Offcanvas Settings
*/
function _header_offcanvas_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_show_offcanvas',
        'label'    => esc_html__('Show Offcanvas', 'apexa'),
        'section'  => 'offcanvas_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'apexa'),
            'off' => esc_html__('Disable', 'apexa'),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_address_title',
        'label'    => esc_html__('Enter Address Title', 'apexa'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('Office Address', 'apexa'),
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'offcanvas_address_text',
        'label'    => esc_html__('Enter Address Text', 'apexa'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('123/A, Miranda City Likaoli Prikano, Dope', 'apexa'),
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_phone_title',
        'label'    => esc_html__('Enter Phone Title', 'apexa'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('Phone Number', 'apexa'),
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'offcanvas_phone_text',
        'label'    => esc_html__('Enter Phone Text', 'apexa'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('+0989 7876 9865 9', 'apexa'),
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_email_title',
        'label'    => esc_html__('Enter Email Title', 'apexa'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('Email Address', 'apexa'),
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'offcanvas_email_text',
        'label'    => esc_html__('Enter Phone Text', 'apexa'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'default'  => esc_html__('info@example.com', 'apexa'),
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_show_offcanvas_social',
        'label'    => esc_html__('Show Offcanvas Social', 'apexa'),
        'section'  => 'offcanvas_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'apexa'),
            'off' => esc_html__('Disable', 'apexa'),
        ],
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_fb',
        'label'    => esc_html__('Enter Facebook url', 'apexa'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'apexa_show_offcanvas_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'apexa'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_twitter',
        'label'    => esc_html__('Enter Twitter url', 'apexa'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'apexa_show_offcanvas_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'apexa'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_instagram',
        'label'    => esc_html__('Enter Instagram url', 'apexa'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'apexa_show_offcanvas_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'apexa'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'offcanvas_pinterest',
        'label'    => esc_html__('Enter Pinterest url', 'apexa'),
        'section'  => 'offcanvas_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_offcanvas',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'apexa_show_offcanvas_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('#', 'apexa'),
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_offcanvas_fields' );


/*
Mobile Menu Settings
*/
function _mobile_menu_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_show_mobile_search',
        'label'    => esc_html__( 'Show Mobile Menu Search', 'apexa' ),
        'section'  => 'mobile_menu_setting',
        'default'  => 0,
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'apexa' ),
            'off' => esc_html__( 'Disable', 'apexa' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_show_mobile_contact',
        'label'    => esc_html__('Show Mobile Contact', 'apexa'),
        'section'  => 'mobile_menu_setting',
        'default'  => '0',
        'priority' => 11,
        'choices'  => [
            'on'  => esc_html__('Enable', 'apexa'),
            'off' => esc_html__('Disable', 'apexa'),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_mobile_phone_text',
        'label'    => esc_html__('Enter Phone Number', 'apexa'),
        'section'  => 'mobile_menu_setting',
        'priority' => 11,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_mobile_contact',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('+123 9898 500', 'apexa'),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_mobile_email_text',
        'label'    => esc_html__('Enter Email Address', 'apexa'),
        'section'  => 'mobile_menu_setting',
        'priority' => 11,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_mobile_contact',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__('info@apexa.com', 'apexa'),
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_show_mobile_social',
        'label'    => esc_html__( 'Show Mobile Menu Social', 'apexa' ),
        'section'  => 'mobile_menu_setting',
        'default'  => 0,
        'priority' => 12,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'apexa' ),
            'off' => esc_html__( 'Disable', 'apexa' ),
        ],
    ];

    // Mobile section social
    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_mobile_fb_url',
        'label'    => esc_html__( 'Facebook URL', 'apexa' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'apexa' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_mobile_twitter_url',
        'label'    => esc_html__( 'Twitter URL', 'apexa' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'apexa' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_mobile_instagram_url',
        'label'    => esc_html__( 'Instagram URL', 'apexa' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'apexa' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_mobile_linkedin_url',
        'label'    => esc_html__( 'Linkedin URL', 'apexa' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'apexa' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_mobile_telegram_url',
        'label'    => esc_html__( 'Telegram URL', 'apexa' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'apexa' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'apexa_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_mobile_menu_fields' );


/*
_header_page_title_fields
 */
function _header_page_title_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'breadcrumb_hide_default',
        'label'    => esc_html__('Breadcrumb Hide by Default', 'apexa'),
        'section'  => 'breadcrumb_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'apexa'),
            'off' => esc_html__('Disable', 'apexa'),
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'breadcrumb_bg_img',
        'label'       => esc_html__('Breadcrumb Background Image', 'apexa'),
        'description' => esc_html__('Upload Image', 'apexa'),
        'section'     => 'breadcrumb_setting',
        'default'     => get_template_directory_uri() . '/assets/img/bg/breadcrumb_bg.jpg',
        'active_callback'  => [
            [
                'setting'  => 'breadcrumb_hide_default',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'apexa_breadcrumb_bg_color',
        'label'       => __('Breadcrumb BG Color', 'apexa'),
        'description' => esc_html__('This is a Breadcrumb bg color control.', 'apexa'),
        'section'     => 'breadcrumb_setting',
        'default'     => '#ECF6FA',
        'priority'    => 11,
        'active_callback'  => [
            [
                'setting'  => 'breadcrumb_hide_default',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'breadcrumb_info_switch',
        'label'    => esc_html__( 'Breadcrumb Nav Hide', 'apexa' ),
        'section'  => 'breadcrumb_setting',
        'default'  => '0',
        'priority' => 12,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'apexa' ),
            'off' => esc_html__( 'Disable', 'apexa' ),
        ],
        'active_callback'  => [
            [
                'setting'  => 'breadcrumb_hide_default',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'breadcrumb_shape_hide',
        'label'    => esc_html__('Breadcrumb Shape Hide', 'apexa'),
        'section'  => 'breadcrumb_setting',
        'default'  => '0',
        'priority' => 13,
        'choices'  => [
            'on'  => esc_html__('Enable', 'apexa'),
            'off' => esc_html__('Disable', 'apexa'),
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'breadcrumb_shape_one',
        'label'       => esc_html__('Breadcrumb Shape One', 'apexa'),
        'description' => esc_html__('Upload Your Shape', 'apexa'),
        'section'     => 'breadcrumb_setting',
        'default'     => get_template_directory_uri() . '/assets/img/images/breadcrumb_shape01.png',
        'priority' => 13,
        'active_callback'  => [
            [
                'setting'  => 'breadcrumb_shape_hide',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'breadcrumb_shape_two',
        'label'       => esc_html__('Breadcrumb Shape Two', 'apexa'),
        'description' => esc_html__('Upload Your Shape', 'apexa'),
        'section'     => 'breadcrumb_setting',
        'default'     => get_template_directory_uri() . '/assets/img/images/breadcrumb_shape02.png',
        'priority' => 13,
        'active_callback'  => [
            [
                'setting'  => 'breadcrumb_shape_hide',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'breadcrumb_shape_three',
        'label'       => esc_html__('Breadcrumb Shape Three', 'apexa'),
        'description' => esc_html__('Upload Your Shape', 'apexa'),
        'section'     => 'breadcrumb_setting',
        'default'     => get_template_directory_uri() . '/assets/img/images/breadcrumb_shape03.png',
        'priority' => 13,
        'active_callback'  => [
            [
                'setting'  => 'breadcrumb_shape_hide',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_page_title_fields' );

/*
Header Social
 */
function _header_blog_fields( $fields ) {
// Blog Setting
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_blog_btn_switch',
        'label'    => esc_html__( 'Blog Button ON/OFF', 'apexa' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'apexa' ),
            'off' => esc_html__( 'Disable', 'apexa' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_blog_cat',
        'label'    => esc_html__( 'Blog Category Meta ON/OFF', 'apexa' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'apexa' ),
            'off' => esc_html__( 'Disable', 'apexa' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_blog_author',
        'label'    => esc_html__( 'Blog Author Meta ON/OFF', 'apexa' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'apexa' ),
            'off' => esc_html__( 'Disable', 'apexa' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_blog_date',
        'label'    => esc_html__( 'Blog Date Meta ON/OFF', 'apexa' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'apexa' ),
            'off' => esc_html__( 'Disable', 'apexa' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_blog_comments',
        'label'    => esc_html__( 'Blog Comments Meta ON/OFF', 'apexa' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'apexa' ),
            'off' => esc_html__( 'Disable', 'apexa' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_show_blog_share',
        'label'    => esc_html__( 'Show Blog Share', 'apexa' ),
        'section'  => 'blog_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'apexa' ),
            'off' => esc_html__( 'Disable', 'apexa' ),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_blog_btn',
        'label'    => esc_html__( 'Blog Button text', 'apexa' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Read More', 'apexa' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'breadcrumb_blog_title',
        'label'    => esc_html__( 'Blog Title', 'apexa' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Blog', 'apexa' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'breadcrumb_blog_title_details',
        'label'    => esc_html__( 'Blog Details Title', 'apexa' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Blog Details', 'apexa' ),
        'priority' => 10,
    ];
    return $fields;
}
add_filter( 'kirki/fields', '_header_blog_fields' );

/*
Footer
 */
function _header_footer_fields( $fields ) {
    // Footer Setting
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'apexa_footer_elementor_switch',
        'label'       => esc_html__('Elementor Footer Switch', 'apexa'),
        'section'  => 'footer_setting',
        'default'  => 0,
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'apexa'),
            'off' => esc_html__('Disable', 'apexa'),
        ],
    ];

    $fields[] = [
        'type'        => 'radio-image',
        'settings'    => 'choose_default_footer',
        'label'       => esc_html__( 'Choose Footer Style', 'apexa' ),
        'section'     => 'footer_setting',
        'default'     => '5',
        'placeholder' => esc_html__( 'Select an option...', 'apexa' ),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            'footer-style-1'   => get_template_directory_uri() . '/inc/img/footer/footer-1.png',
        ],
        'default'     => 'footer-style-1',
        'active_callback' => [
            [
                'setting' => 'apexa_footer_elementor_switch',
                'operator' => '==',
                'value' => false
            ]
        ]
    ];

    $footer_posttype = array(
        'post_type'      => 'apexa-footer',
        'posts_per_page' => -1,
    );
    $footer_posttype_loop = get_posts($footer_posttype);
    $footer_post_obj_arr = array();
    foreach ($footer_posttype_loop as $post) {
        $footer_post_obj_arr[$post->ID] = $post->post_title;
    }

    wp_reset_postdata();

    $fields[] = [
        'type'     => 'select',
        'settings' => 'apexa_footer_templates',
        'label'       => esc_html__('Elementor Footer Template', 'apexa'),
        'section'  => 'footer_setting',
        'description' => esc_html__('If you select a Footer Style from the edit page, This option will not work. So go to edit page then change the footer style.', 'apexa'),
        'priority' => 11,
        'placeholder' => esc_html__('Choose an option', 'apexa'),
        'choices'     => $footer_post_obj_arr,
        'active_callback' => [
            [
                'setting' => 'apexa_footer_elementor_switch',
                'operator' => '==',
                'value' => true
            ]
        ]
    ];

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'footer_widget_number',
        'label'       => esc_html__( 'Widget Number', 'apexa' ),
        'section'     => 'footer_setting',
        'default'     => '4',
        'placeholder' => esc_html__( 'Select an option...', 'apexa' ),
        'priority'    => 11,
        'multiple'    => 1,
        'choices'     => [
            '4' => esc_html__( 'Widget Number 4', 'apexa' ),
            '3' => esc_html__( 'Widget Number 3', 'apexa' ),
            '2' => esc_html__( 'Widget Number 2', 'apexa' ),
        ],
        'active_callback' => [
            [
                'setting' => 'apexa_footer_elementor_switch',
                'operator' => '==',
                'value' => false
            ]
        ]
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'apexa_footer_bg_color',
        'label'       => __( 'Footer BG Color', 'apexa' ),
        'description' => esc_html__( 'This is a Footer bg color control.', 'apexa' ),
        'section'     => 'footer_setting',
        'default'     => '#0E104B',
        'priority'    => 12,
        'active_callback' => [
            [
                'setting' => 'apexa_footer_elementor_switch',
                'operator' => '==',
                'value' => false
            ]
        ]
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_copyright',
        'label'    => esc_html__( 'CopyRight Text', 'apexa' ),
        'section'  => 'footer_setting',
        'default'  => esc_html__( 'Copyright © Apexa 2023. All Rights Reserved', 'apexa' ),
        'priority' => 15,
        'active_callback' => [
            [
                'setting' => 'apexa_footer_elementor_switch',
                'operator' => '==',
                'value' => false
            ]
        ]
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_footer_fields' );

// color
function apexa_color_fields( $fields ) {

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'apexa_color_option',
        'label'       => __( 'Primary Color', 'apexa' ),
        'description' => esc_html__('This is a Primary color control.', 'apexa' ),
        'section'     => 'color_setting',
        'default'     => '#F7A400',
        'priority'    => 10,
    ];

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'apexa_color_option2',
        'label'       => __('Secondary Color', 'apexa' ),
        'description' => esc_html__('This is a Secondary color control.', 'apexa' ),
        'section'     => 'color_setting',
        'default'     => '#191D88',
        'priority'    => 10,
    ];

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'apexa_color_option3',
        'label'       => __('Dark Blue Color', 'apexa' ),
        'description' => esc_html__('This is a Dark color control.', 'apexa' ),
        'section'     => 'color_setting',
        'default'     => '#0E104B',
        'priority'    => 10,
    ];

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'apexa_color_option4',
        'label'       => __('Heading Text Color', 'apexa' ),
        'description' => esc_html__('This is a Heading Text color control.', 'apexa' ),
        'section'     => 'color_setting',
        'default'     => '#14176C',
        'priority'    => 10,
    ];

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'apexa_color_option5',
        'label'       => __('Body Text Color', 'apexa' ),
        'description' => esc_html__('This is a Body Text color control.', 'apexa' ),
        'section'     => 'color_setting',
        'default'     => '#3E4073',
        'priority'    => 10,
    ];

    return $fields;
}
add_filter( 'kirki/fields', 'apexa_color_fields' );

// 404
function apexa_404_fields( $fields ) {

    // 404 settings
    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_error_text',
        'label'    => esc_html__('404 Text', 'apexa'),
        'section'  => '404_page',
        'default'  => esc_html__('OOPS! Nothing Was Found', 'apexa'),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'apexa_error_title',
        'label'    => esc_html__( 'Not Found Title', 'apexa' ),
        'section'  => '404_page',
        'default'  => esc_html__('Sorry, the page you are looking for could not be found', 'apexa' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_error_link_text',
        'label'    => esc_html__( '404 Link Text', 'apexa' ),
        'section'  => '404_page',
        'default'  => esc_html__('Go Back To Home Page', 'apexa' ),
        'priority' => 10,
    ];
    return $fields;
}
add_filter( 'kirki/fields', 'apexa_404_fields' );


/**
 * Added Fields
 */
function apexa_typo_fields( $fields ) {
    // typography settings
    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_body_setting',
        'label'       => esc_html__( 'Body Font', 'apexa' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
            'text-transform'  => 'none',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => ['body', 'p'],
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h_setting',
        'label'       => esc_html__( 'Heading Fonts', 'apexa' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
            'text-transform'  => 'none',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => ['h1', 'h2', 'h3', 'h4', 'h5', 'h6'],
            ],
        ],
    ];

    return $fields;
}

add_filter( 'kirki/fields', 'apexa_typo_fields' );


/**
 * Added Fields
 */
function apexa_slug_setting( $fields ) {
    // slug settings
    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_services_slug',
        'label'    => esc_html__( 'Services Slug', 'apexa' ),
        'section'  => 'slug_setting',
        'default'  => esc_html__('services', 'apexa' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'apexa_project_slug',
        'label'    => esc_html__( 'Project Slug', 'apexa' ),
        'section'  => 'slug_setting',
        'default'  => esc_html__('project', 'apexa' ),
        'priority' => 10,
    ];

    return $fields;
}

add_filter( 'kirki/fields', 'apexa_slug_setting' );

/**
 * This is a short hand function for getting setting value from customizer
 *
 * @param string $name
 *
 * @return bool|string
 */
function APEXA_THEME_OPTION( $name ) {
    $value = '';
    if ( class_exists( 'apexa' ) ) {
        $value = Kirki::get_option( apexa_get_theme(), $name );
    }

    return apply_filters('APEXA_THEME_OPTION', $value, $name );
}

/**
 * Get config ID
 *
 * @return string
 */
function apexa_get_theme() {
    return 'apexa';
}