<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package apexa
 */


/**
 *
 * Apexa Header
 */

function apexa_check_header()
{

    $apexa_header_tabs = function_exists('get_field') ? get_field('genix_header') : false;
    $elementor_header_template_meta = function_exists('get_field') ? get_field('elementor_header_style') : false;

    $apexa_header_option_switch = get_theme_mod('apexa_header_elementor_switch', false);
    $elementor_header_templates_kirki = get_theme_mod('apexa_header_templates');

    if ($apexa_header_tabs == 'default') {
        if ($apexa_header_option_switch) {
            if ($elementor_header_templates_kirki) {
                echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_header_templates_kirki);
            }
        } else {
            get_template_part('template-parts/header/header-1');
        }
    } elseif ($apexa_header_tabs == 'elementor') {
        if ($elementor_header_template_meta) {
            echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_header_template_meta);
        } else {
            echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_header_templates_kirki);
        }
    } else {
        if ($apexa_header_option_switch) {

            if ($elementor_header_templates_kirki) {
                echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_header_templates_kirki);
            } else {
                get_template_part('template-parts/header/header-1');
            }
        } else {
            get_template_part('template-parts/header/header-1');
        }
    }
}
add_action( 'apexa_header_style', 'apexa_check_header', 10 );


/**
 * [apexa_header_lang description]
 * @return [type] [description]
 */
function apexa_header_lang_default() {
    $apexa_header_lang = get_theme_mod( 'apexa_header_lang', false );
    if ( $apexa_header_lang ): ?>

    <ul>
        <li><a href="javascript:void(0)" class="lang__btn"><?php print esc_html__( 'English', 'apexa' );?> <i class="fa-light fa-angle-down"></i></a>
        <?php do_action( 'apexa_language' );?>
        </li>
    </ul>

    <?php endif;?>
<?php
}

/**
 * [apexa_language_list description]
 * @return [type] [description]
 */
function _apexa_language( $mar ) {
    return $mar;
}
function apexa_language_list() {

    $mar = '';
    $languages = apply_filters( 'wpml_active_languages', NULL, 'orderby=id&order=desc' );
    if ( !empty( $languages ) ) {
        $mar = '<div class="dropdown-menu" aria-labelledby="dropdownMenuButton1">';
        foreach ( $languages as $lan ) {
            $active = $lan['active'] == 1 ? 'active' : '';
            $mar .= '<a href="' . $lan['url'] . '" class="' . $active . '">' . $lan['translated_name'] . '</a>';
        }
        $mar .= '</div>';
    } else {
        //remove this code when send themeforest reviewer team
        $mar .= '<div class="dropdown-menu" aria-labelledby="dropdownMenuButton1">';
        $mar .= '<a href="#" class="dropdown-item">' . esc_html__( '🇷🇺 Russia', 'apexa' ) . '</a>';
        $mar .= '<a href="#" class="dropdown-item">' . esc_html__( '🇮🇳 India', 'apexa' ) . '</a>';
        $mar .= '<a href="#" class="dropdown-item">' . esc_html__( '🇹🇷 Turkey', 'apexa' ) . '</a>';
        $mar .= '<a href="#" class="dropdown-item">' . esc_html__( '🇫🇷 France', 'apexa' ) . '</a>';
        $mar .= ' </div>';
    }
    print _apexa_language( $mar );
}
add_action( 'apexa_language', 'apexa_language_list' );


// Header Logo
function apexa_header_logo() { ?>
      <?php
        $apexa_logo_on = function_exists( 'get_field' ) ? get_field( 'is_enable_sec_logo' ) : NULL;
        $apexa_logo = get_template_directory_uri() . '/assets/img/logo/logo.png';
        $apexa_logo_black = get_template_directory_uri() . '/assets/img/logo/secondary_logo.png';

        $apexa_site_logo = get_theme_mod( 'logo', $apexa_logo );
        $apexa_secondary_logo = get_theme_mod( 'secondary_logo', $apexa_logo_black );
      ?>

      <?php if ( !empty( $apexa_logo_on ) ) : ?>
         <a class="secondary-logo" href="<?php print esc_url( home_url( '/' ) );?>">
             <img src="<?php print esc_url( $apexa_secondary_logo );?>" style="max-height: <?php echo get_theme_mod( 'logo_size_adjust', '34px' ); ?>" alt="<?php print esc_attr__( 'Logo', 'apexa' );?>" />
         </a>
      <?php else : ?>
         <a class="main-logo" href="<?php print esc_url( home_url( '/' ) );?>">
             <img src="<?php print esc_url( $apexa_site_logo );?>" style="max-height: <?php echo get_theme_mod( 'logo_size_adjust', '34px' ); ?>" alt="<?php print esc_attr__( 'Logo', 'apexa' );?>" />
         </a>
      <?php endif; ?>
   <?php
}

// Header Sticky Logo
function apexa_header_sticky_logo() {?>
    <?php
        $apexa_logo = get_template_directory_uri() . '/assets/img/logo/logo.png';
        $apexa_site_logo = get_theme_mod( 'logo', $apexa_logo );
    ?>
      <a class="sticky-logo" href="<?php print esc_url( home_url( '/' ) );?>">
          <img src="<?php print esc_url( $apexa_site_logo );?>" style="max-height: <?php echo get_theme_mod( 'logo_size_adjust', '34px' ); ?>" alt="<?php print esc_attr__( 'Logo', 'apexa' );?>" />
      </a>
    <?php
}

// Mobile Menu Logo
function apexa_mobile_logo() {

    $mobile_menu_logo = get_template_directory_uri() . '/assets/img/logo/logo.png';
    $mobile_logo = get_theme_mod('mobile_logo', $mobile_menu_logo);

    ?>

    <a class="main-logo" href="<?php print esc_url( home_url( '/' ) ); ?>">
        <img src="<?php print esc_url( $mobile_logo ); ?>" style="max-height: <?php echo get_theme_mod( 'logo_size_adjust', '34px' ); ?>" alt="<?php print esc_attr__( 'Logo', 'apexa' );?>" />
    </a>

<?php }


/**
 * [apexa_header_social_profiles description]
 * @return [type] [description]
 */
function apexa_header_social_profiles() {
    $apexa_header_fb_url = get_theme_mod( 'apexa_header_fb_url', __( '#', 'apexa' ) );
    $apexa_header_twitter_url = get_theme_mod( 'apexa_header_twitter_url', __( '#', 'apexa' ) );
    $apexa_header_linkedin_url = get_theme_mod( 'apexa_header_linkedin_url', __( '#', 'apexa' ) );
    ?>
    <ul>
        <?php if ( !empty( $apexa_header_fb_url ) ): ?>
          <li><a href="<?php print esc_url( $apexa_header_fb_url );?>"><span><i class="flaticon-facebook"></i></span></a></li>
        <?php endif;?>

        <?php if ( !empty( $apexa_header_twitter_url ) ): ?>
            <li><a href="<?php print esc_url( $apexa_header_twitter_url );?>"><span><i class="flaticon-twitter"></i></span></a></li>
        <?php endif;?>

        <?php if ( !empty( $apexa_header_linkedin_url ) ): ?>
            <li><a href="<?php print esc_url( $apexa_header_linkedin_url );?>"><span><i class="flaticon-linkedin"></i></span></a></li>
        <?php endif;?>
    </ul>

<?php
}

function apexa_footer_social_profiles() {
    $apexa_footer_fb_url = get_theme_mod( 'apexa_footer_fb_url', __( '#', 'apexa' ) );
    $apexa_footer_twitter_url = get_theme_mod( 'apexa_footer_twitter_url', __( '#', 'apexa' ) );
    $apexa_footer_vimeo_url = get_theme_mod( 'apexa_footer_vimeo_url', __( '#', 'apexa' ) );
    $apexa_footer_youtube_url = get_theme_mod( 'apexa_footer_youtube_url', __( '#', 'apexa' ) );
    ?>

        <ul>
        <?php if ( !empty( $apexa_footer_fb_url ) ): ?>
            <li>
                <a href="<?php print esc_url( $apexa_footer_fb_url );?>">
                    <i class="fab fa-facebook-square"></i>
                </a>
            </li>
        <?php endif;?>

        <?php if ( !empty( $apexa_footer_twitter_url ) ): ?>
            <li>
                <a href="<?php print esc_url( $apexa_footer_twitter_url );?>">
                    <i class="fab fa-twitter"></i>
                </a>
            </li>
        <?php endif;?>

        <?php if ( !empty( $apexa_footer_vimeo_url ) ): ?>
            <li>
                <a href="<?php print esc_url( $apexa_footer_vimeo_url );?>">
                    <i class="fab fa-vimeo-v"></i>
                </a>
            </li>
        <?php endif;?>

        <?php if ( !empty( $apexa_footer_youtube_url ) ): ?>
            <li>
                <a href="<?php print esc_url( $apexa_footer_youtube_url );?>">
                    <i class="fab fa-youtube"></i>
                </a>
            </li>
        <?php endif;?>
        </ul>
<?php
}

/**
 * [apexa_mobile_social_profiles description]
 * @return [type] [description]
 */
function apexa_mobile_social_profiles() {
    $apexa_mobile_fb_url           = get_theme_mod('apexa_mobile_fb_url', __('#','apexa'));
    $apexa_mobile_twitter_url      = get_theme_mod('apexa_mobile_twitter_url', __('#','apexa'));
    $apexa_mobile_instagram_url    = get_theme_mod('apexa_mobile_instagram_url', __('#','apexa'));
    $apexa_mobile_linkedin_url     = get_theme_mod('apexa_mobile_linkedin_url', __('#','apexa'));
    $apexa_mobile_telegram_url      = get_theme_mod('apexa_mobile_telegram_url', __('#','apexa'));
    ?>

    <ul class="clearfix">
        <?php if (!empty($apexa_mobile_fb_url)): ?>
        <li class="facebook">
            <a href="<?php print esc_url($apexa_mobile_fb_url); ?>"><i class="fab fa-facebook-f"></i></a>
        </li>
        <?php endif; ?>

        <?php if (!empty($apexa_mobile_twitter_url)): ?>
        <li class="twitter">
            <a href="<?php print esc_url($apexa_mobile_twitter_url); ?>"><i class="fab fa-twitter"></i></a>
        </li>
        <?php endif; ?>

        <?php if (!empty($apexa_mobile_instagram_url)): ?>
        <li class="instagram">
            <a href="<?php print esc_url($apexa_mobile_instagram_url); ?>"><i class="fab fa-instagram"></i></a>
        </li>
        <?php endif; ?>

        <?php if (!empty($apexa_mobile_linkedin_url)): ?>
        <li class="linkedin">
            <a href="<?php print esc_url($apexa_mobile_linkedin_url); ?>"><i class="fab fa-linkedin-in"></i></a>
        </li>
        <?php endif; ?>

        <?php if (!empty($apexa_mobile_telegram_url)): ?>
        <li class="telegram">
            <a href="<?php print esc_url($apexa_mobile_telegram_url); ?>"><i class="fab fa-telegram-plane"></i></a>
        </li>
        <?php endif; ?>
    </ul>

<?php
}


/**
 * [apexa_header_menu description]
 * @return [type] [description]
 */
function apexa_header_menu() {
    ?>
    <?php
        wp_nav_menu( [
            'theme_location' => 'main-menu',
            'menu_class'     => 'navigation',
            'container'      => '',
            'fallback_cb'    => 'Apexa_Navwalker_Class::fallback',
            'walker'         => new Apexa_Navwalker_Class,
        ] );
    ?>
    <?php
}


/**
 * [apexa_hamburger_menu description]
 * @return [type] [description]
 */
function apexa_hamburger_menu() {
    ?>
    <?php
        wp_nav_menu( [
            'theme_location' => 'hamburger-menu',
            'menu_class'     => 'navigation',
            'container'      => '',
            'fallback_cb'    => 'Apexa_Navwalker_Class::fallback',
            'walker'         => new Apexa_Navwalker_Class,
        ] );
    ?>
    <?php
}

/**
 * [apexa_header_menu description]
 * @return [type] [description]
 */
function apexa_mobile_menu() { ?>
    <?php
        $apexa_menu = wp_nav_menu( [
            'theme_location' => 'main-menu',
            'menu_class'     => 'navigation',
            'container'      => '',
            'fallback_cb'    => false,
            'echo'           => false,
        ] );

    $apexa_menu = str_replace( "menu-item-has-children", "menu-item-has-children has-children", $apexa_menu );
        echo wp_kses_post( $apexa_menu );
    ?>
    <?php
}

/**
 * [apexa_blog_mobile_menu description]
 * @return [type] [description]
 */
function apexa_blog_mobile_menu() { ?>
    <?php
        $apexa_menu = wp_nav_menu( [
            'theme_location' => 'blog-menu',
            'menu_class'     => 'navigation',
            'container'      => '',
            'fallback_cb'    => false,
            'echo'           => false,
        ] );

    $apexa_menu = str_replace( "menu-item-has-children", "menu-item-has-children has-children", $apexa_menu );
        echo wp_kses_post( $apexa_menu );
    ?>
    <?php
}

/**
 * [apexa_search_menu description]
 * @return [type] [description]
 */
function apexa_header_search_menu() { ?>
    <?php
        wp_nav_menu( [
            'theme_location' => 'header-search-menu',
            'menu_class'     => '',
            'container'      => '',
            'fallback_cb'    => 'Apexa_Navwalker_Class::fallback',
            'walker'         => new Apexa_Navwalker_Class,
        ] );
    ?>
    <?php
}

/**
 * [apexa_footer_menu description]
 * @return [type] [description]
 */
function apexa_footer_menu() {
    wp_nav_menu( [
        'theme_location' => 'footer-menu',
        'menu_class'     => 'navigation',
        'container'      => '',
        'fallback_cb'    => 'Apexa_Navwalker_Class::fallback',
        'walker'         => new Apexa_Navwalker_Class,
    ] );
}


/**
 * [apexa_category_menu description]
 * @return [type] [description]
 */
function apexa_category_menu() {
    wp_nav_menu( [
        'theme_location' => 'category-menu',
        'menu_class'     => 'cat-submenu m-0',
        'container'      => '',
        'fallback_cb'    => 'Apexa_Navwalker_Class::fallback',
        'walker'         => new Apexa_Navwalker_Class,
    ] );
}

/**
 *
 * apexa footer
 */
function apexa_check_footer() {

    $apexa_footer_tabs = function_exists('get_field') ? get_field('genix_footer') : false;
    $elementor_footer_template_meta = function_exists('get_field') ? get_field('elementor_footer_style') : false;

    $apexa_footer_option_switch = get_theme_mod('apexa_footer_elementor_switch', false);
    $elementor_footer_templates_kirki = get_theme_mod('apexa_footer_templates');

    if ($apexa_footer_tabs == 'default') {
        if ($apexa_footer_option_switch) {
            if ($elementor_footer_templates_kirki) {
                echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_footer_templates_kirki);
            }
        } else {
            get_template_part('template-parts/footer/footer-1');
        }
    } elseif ($apexa_footer_tabs == 'elementor') {
        if ($elementor_footer_template_meta) {
            echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_footer_template_meta);
        } else {
            echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_footer_templates_kirki);
        }
    } else {
        if ($apexa_footer_option_switch) {

            if ($elementor_footer_templates_kirki) {
                echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_footer_templates_kirki);
            } else {
                get_template_part('template-parts/footer/footer-1');
            }
        } else {
            get_template_part('template-parts/footer/footer-1');
        }
    }
}

add_action('apexa_footer_style', 'apexa_check_footer', 10);


// apexa_copyright_text
function apexa_copyright_text() {
   print get_theme_mod( 'apexa_copyright', esc_html__( 'Copyright © Apexa 2024. All Rights Reserved', 'apexa' ) );
}


/**
 *
 * pagination
 */
if ( !function_exists( 'apexa_pagination' ) ) {

    function _apexa_pagi_callback( $pagination ) {
        return $pagination;
    }

    //page navegation
    function apexa_pagination( $prev, $next, $pages, $args ) {
        global $wp_query, $wp_rewrite;
        $menu = '';
        $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;

        if ( $pages == '' ) {
            global $wp_query;
            $pages = $wp_query->max_num_pages;

            if ( !$pages ) {
                $pages = 1;
            }

        }

        $pagination = [
            'base'      => add_query_arg( 'paged', '%#%' ),
            'format'    => '',
            'total'     => $pages,
            'current'   => $current,
            'prev_text' => $prev,
            'next_text' => $next,
            'type'      => 'array',
        ];

        //rewrite permalinks
        if ( $wp_rewrite->using_permalinks() ) {
            $pagination['base'] = user_trailingslashit( trailingslashit( remove_query_arg( 's', get_pagenum_link( 1 ) ) ) . 'page/%#%/', 'paged' );
        }

        if ( !empty( $wp_query->query_vars['s'] ) ) {
            $pagination['add_args'] = ['s' => get_query_var( 's' )];
        }

        $pagi = '';
        if ( paginate_links( $pagination ) != '' ) {
            $paginations = paginate_links( $pagination );
            $pagi .= '<ul class="pagination">';
            foreach ( $paginations as $key => $pg ) {
                $pagi .= '<li class="page-item">' . $pg . '</li>';
            }
            $pagi .= '</ul>';
        }

        print _apexa_pagi_callback( $pagi );
    }
}


// theme color
function apexa_custom_color() {

    // Primary Color
    $color_code = get_theme_mod( 'apexa_color_option', '#F7A400' );
    wp_enqueue_style( 'apexa-custom', APEXA_THEME_CSS_DIR . 'apexa-custom.css', [] );
    if ( $color_code != '' ) {
        $custom_css = '';
        $custom_css .= "html:root { --tg-theme-primary: " . $color_code . "}";
        $custom_css .= "html:root { --unit-primary-color: " . $color_code . "}";
        wp_add_inline_style( 'apexa-custom', $custom_css );
    }

    // Secondary Color
    $color_code2 = get_theme_mod( 'apexa_color_option2', '#191D88' );
    wp_enqueue_style( 'apexa-custom', APEXA_THEME_CSS_DIR . 'apexa-custom.css', [] );
    if ( $color_code2 != '' ) {
        $custom_css = '';
        $custom_css .= "html:root { --tg-theme-secondary: " . $color_code2 . "}";
        $custom_css .= "html:root { --unit-secondary-color: " . $color_code2 . "}";
        wp_add_inline_style( 'apexa-custom', $custom_css );
    }

    // Dark Blue Color
    $color_code3 = get_theme_mod( 'apexa_color_option3', '#0E104B' );
    wp_enqueue_style( 'apexa-custom', APEXA_THEME_CSS_DIR . 'apexa-custom.css', [] );
    if ( $color_code3 != '' ) {
        $custom_css = '';
        $custom_css .= "html:root { --tg-color-dark-blue: " . $color_code3 . "}";
        wp_add_inline_style( 'apexa-custom', $custom_css );
    }

    // Heading Text Color
    $color_code4 = get_theme_mod( 'apexa_color_option4', '#14176C' );
    wp_enqueue_style( 'apexa-custom', APEXA_THEME_CSS_DIR . 'apexa-custom.css', [] );
    if ( $color_code4 != '' ) {
        $custom_css = '';
        $custom_css .= "html:root { --tg-heading-color: " . $color_code4 . "}";
        wp_add_inline_style( 'apexa-custom', $custom_css );
    }

    // Body Text Color
    $color_code5 = get_theme_mod( 'apexa_color_option5', '#3E4073' );
    wp_enqueue_style( 'apexa-custom', APEXA_THEME_CSS_DIR . 'apexa-custom.css', [] );
    if ( $color_code5 != '' ) {
        $custom_css = '';
        $custom_css .= "html:root { --tg-body-color: " . $color_code5 . "}";
        wp_add_inline_style( 'apexa-custom', $custom_css );
    }

}
add_action( 'wp_enqueue_scripts', 'apexa_custom_color' );



// apexa_kses_intermediate
function apexa_kses_intermediate( $string = '' ) {
    return wp_kses( $string, apexa_get_allowed_html_tags( 'intermediate' ) );
}

function apexa_get_allowed_html_tags( $level = 'basic' ) {
    $allowed_html = [
        'b'      => [],
        'i'      => [],
        'u'      => [],
        'em'     => [],
        'br'     => [],
        'abbr'   => [
            'title' => [],
        ],
        'span'   => [
            'class' => [],
        ],
        'strong' => [],
        'a'      => [
            'href'  => [],
            'title' => [],
            'class' => [],
            'id'    => [],
        ],
    ];

    if ($level === 'intermediate') {
        $allowed_html['a'] = [
            'href' => [],
            'title' => [],
            'class' => [],
            'id' => [],
        ];
        $allowed_html['div'] = [
            'class' => [],
            'id' => [],
        ];
        $allowed_html['img'] = [
            'src' => [],
            'class' => [],
            'alt' => [],
        ];
        $allowed_html['del'] = [
            'class' => [],
        ];
        $allowed_html['ins'] = [
            'class' => [],
        ];
        $allowed_html['bdi'] = [
            'class' => [],
        ];
        $allowed_html['i'] = [
            'class' => [],
            'data-rating-value' => [],
        ];
    }

    return $allowed_html;
}



// WP kses allowed tags
// ----------------------------------------------------------------------------------------
function apexa_kses($raw){

   $allowed_tags = array(
      'a'      => array(
         'class'   => array(),
         'href'    => array(),
         'rel'  => array(),
         'title'   => array(),
         'target' => array(),
      ),
      'abbr'   => array(
         'title' => array(),
      ),
      'b'    => array(),
      'blockquote'   => array(
         'cite' => array(),
      ),
      'cite'   => array(
         'title' => array(),
      ),
      'code'  => array(),
      'del'   => array(
         'datetime'   => array(),
         'title'      => array(),
      ),
      'dd'     => array(),
      'div'    => array(
         'class'   => array(),
         'title'   => array(),
         'style'   => array(),
      ),
      'dl'   => array(),
      'dt'   => array(),
      'em'   => array(),
      'h1'   => array(),
      'h2'   => array(),
      'h3'   => array(),
      'h4'   => array(),
      'h5'   => array(),
      'h6'   => array(),
      'i'    => array(
        'class' => array(),
      ),
      'img'   => array(
         'alt'  => array(),
         'class'   => array(),
         'height' => array(),
         'src'  => array(),
         'width'   => array(),
      ),
      'li'   => array(
         'class' => array(),
      ),
      'ol'   => array(
         'class' => array(),
      ),
      'p'    => array(
         'class' => array(),
      ),
      'q'    => array(
         'cite'    => array(),
         'title'   => array(),
      ),
      'span'  => array(
         'class'   => array(),
         'title'   => array(),
         'style'   => array(),
      ),
      'iframe'   => array(
         'width'        => array(),
         'height'       => array(),
         'scrolling'    => array(),
         'frameborder'  => array(),
         'allow'        => array(),
         'src'          => array(),
      ),
      'strike'  => array(),
      'br'      => array(),
      'strong'    => array(),
      'data-wow-duration'   => array(),
      'data-wow-delay'   => array(),
      'data-wallpaper-options'  => array(),
      'data-stellar-background-ratio'   => array(),
      'ul'   => array(
         'class' => array(),
      ),
      'svg' => array(
           'class' => true,
           'aria-hidden' => true,
           'aria-labelledby' => true,
           'role' => true,
           'xmlns' => true,
           'width' => true,
           'height' => true,
           'viewbox' => true, // <= Must be lower case!
       ),
       'g'     => array( 'fill' => true ),
       'title' => array( 'title' => true ),
       'path'  => array( 'd' => true, 'fill' => true,  ),
      );

   if (function_exists('wp_kses')) { // WP is here
      $allowed = wp_kses($raw, $allowed_tags);
   } else {
      $allowed = $raw;
   }

   return $allowed;
}