<?php

/**
 * Template part for displaying post meta
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package apexa
 */
$categories = get_the_terms($post->ID, 'category');
$apexa_blog_date = get_theme_mod('apexa_blog_date', true);
$apexa_blog_comments = get_theme_mod('apexa_blog_comments', true);
$apexa_blog_author = get_theme_mod('apexa_blog_author', true);
$apexa_blog_cat = get_theme_mod('apexa_blog_cat', true);

?>

<ul class="list-wrap m-0 p-0 d-flex flex-wrap align-items-center">

    <?php if (!empty($apexa_blog_cat)) : ?>
        <?php $categories = get_the_category();
        if (!empty($categories)) {
            echo '<li class="category"><a href="' . esc_url(get_category_link($categories[0]->term_id)) . '" class="blog__post-tag-two">' . esc_html($categories[0]->name) . '</a></li>';
        }
        ?>
    <?php endif; ?>

    <?php if (!empty($apexa_blog_author)) : ?>
        <li class="author">
            <div class="blog-avatar">
                <div class="avatar-thumb">
                    <img src="<?php echo esc_url(get_avatar_url(get_the_author_meta('ID'), ['size' => '40'])); ?>" alt="<?php the_author(); ?>">
                </div>
                <div class="avatar-content">
                    <p><?php echo esc_html__('By', 'apexa') ?> <a href="<?php print esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php print get_the_author(); ?></a></p>
                </div>
            </div>
        </li>
    <?php endif; ?>

    <?php if (!empty($apexa_blog_date)) : ?>
        <li class="date"><i class="fas fa-calendar-alt"></i> <?php the_time(get_option('date_format')); ?></li>
    <?php endif; ?>

    <?php if (!empty($apexa_blog_comments)) : ?>
        <li class="comments"><i class="far fa-comment"></i> <a href="<?php comments_link(); ?>"><?php comments_number(); ?></a></li>
    <?php endif; ?>

</ul>