<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package apexa
 */

$apexa_show_blog_share = get_theme_mod('apexa_show_blog_share', false);
$apexa_post_tags_width = $apexa_show_blog_share ? 'col-md-7' : 'col-12';

?>
<?php if (is_single()) : ?>

    <article id="post-<?php the_ID(); ?>" <?php post_class('blog__post-two blog-details-wrap format-search'); ?>>

        <?php if (has_post_thumbnail()) : ?>
            <div class="blog__details-thumb">
                <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
            </div>
        <?php endif; ?>

        <div class="blog__details-content">

            <!-- blog meta -->
            <div class="blog-post-meta">
                <?php get_template_part('template-parts/blog/blog-meta'); ?>
            </div>

            <div class="post-text">
                <?php the_content(); ?>
                <?php
                wp_link_pages([
                    'before'      => '<div class="page-links">' . esc_html__('Pages:', 'apexa'),
                    'after'       => '</div>',
                    'link_before' => '<span class="page-number">',
                    'link_after'  => '</span>',
                ]);
                ?>
            </div>

            <?php if (!empty(get_the_tags())) : ?>
                <div class="blog__details-bottom">

                    <div class="row">
                        <div class="<?php echo esc_attr($apexa_post_tags_width); ?>">
                            <?php print apexa_get_tag(); ?>
                        </div>
                        <?php if (!empty($apexa_show_blog_share)) : ?>
                            <div class="col-md-5">
                                <div class="blog-details-social text-md-end">
                                    <h5 class="social-title"><?php echo esc_html__('Social Share :', 'apexa') ?></h5>
                                    <?php apexa_social_share(); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                </div>
            <?php endif; ?>

        </div>
    </article>

<?php else : ?>


    <div class="col-md-6 grid-item grid-sizer">
        <article id="post-<?php the_ID(); ?>" <?php post_class('blog__post-two shine-animate-item format-search'); ?>>

            <?php if (has_post_thumbnail()) : ?>
                <div class="blog__post-thumb-two">
                    <a href="<?php the_permalink(); ?>">
                        <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
                    </a>
                </div>
            <?php endif; ?>

            <div class="blog__post-content-two">
                <!-- blog meta -->
                <div class="blog-post-meta loop-post-meta">
                    <?php get_template_part('template-parts/blog/blog-meta'); ?>
                </div>
                <h2 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                <div class="blog-avatar">
                    <div class="avatar-thumb">
                        <img src="<?php echo esc_url(get_avatar_url(get_the_author_meta('ID'), ['size' => '40'])); ?>" alt="<?php the_author(); ?>">
                    </div>
                    <div class="avatar-content">
                        <p><?php echo esc_html__('By', 'apexa') ?> <a href="<?php print esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php print get_the_author(); ?></a></p>
                    </div>
                </div>
            </div>

        </article>
    </div>

<?php endif; ?>