<?php

/**
 * Template part for displaying header layout one
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package apexa
 */

// Header Settings
$apexa_show_sticky_header = get_theme_mod('apexa_show_sticky_header', false);
$sticky_header = $apexa_show_sticky_header ? 'sticky-header' : 'sticky-default';
$sticky_height = $apexa_show_sticky_header ? '' : 'd-none';

$menu_padding = has_nav_menu('main-menu') ? 'apexa-menu-has-showing' : 'apexa-menu-not-showing';

// Header Top
$apexa_show_header_top = get_theme_mod('apexa_show_header_top', false);
$apexa_header_phone_text = get_theme_mod('apexa_header_phone_text', __('+123 9898 500', 'apexa'));
$apexa_header_location = get_theme_mod('apexa_header_location', __('256 Avenue, Mark Street, Newyork City', 'apexa'));
$apexa_header_email_text = get_theme_mod('apexa_header_email_text', __('info@apexa.com', 'apexa'));
$apexa_header_date = get_theme_mod('apexa_header_date', __('Mon-Fri: 10:00am - 09:00pm', 'apexa'));

// Header Search
$apexa_show_header_search = get_theme_mod('apexa_show_header_search', false);

// Header Button
$apexa_show_header_button = get_theme_mod('apexa_show_header_button', false);
$apexa_header_btn_text = get_theme_mod('apexa_header_btn_text', __('let’s Talk', 'apexa'));
$apexa_header_btn_url = get_theme_mod('apexa_header_btn_url', __('#', 'apexa'));

// Offcanvas Menu
$apexa_show_offcanvas = get_theme_mod('apexa_show_offcanvas', false);

?>


<!-- header-area -->
<header>
    <div id="header-fixed-height" class="<?php echo esc_attr($sticky_height) ?>"></div>
    <?php if (!empty($apexa_show_header_top)) : ?>
        <div class="tg-header__top">
            <div class="container custom-container">
                <div class="row justify-content-center">
                    <?php if (!empty($apexa_header_phone_text || $apexa_header_location)) : ?>
                        <div class="col-lg-6">
                            <ul class="tg-header__top-info left-side list-wrap">
                                <?php if (!empty($apexa_header_phone_text)) : ?>
                                    <li><i class="flaticon-phone-call"></i><a href="tel:<?php echo esc_attr($apexa_header_phone_text); ?>"><?php echo esc_html($apexa_header_phone_text); ?></a></li>
                                <?php endif; ?>
                                <?php if (!empty($apexa_header_location)) : ?>
                                    <li><i class="flaticon-pin"></i><?php echo esc_html($apexa_header_location); ?></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($apexa_header_email_text || $apexa_header_date)) : ?>
                        <div class="col-lg-6">
                            <ul class="tg-header__top-right list-wrap">
                                <?php if (!empty($apexa_header_email_text)) : ?>
                                    <li><i class="flaticon-envelope"></i><a href="mailto:<?php echo esc_attr($apexa_header_email_text); ?>"><?php echo esc_html($apexa_header_email_text); ?></a></li>
                                <?php endif; ?>
                                <?php if (!empty($apexa_header_date)) : ?>
                                    <li><i class="flaticon-time"></i><?php echo esc_html($apexa_header_date); ?></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <div id="<?php echo esc_attr($sticky_header); ?>" class="tg-header__area <?php echo esc_attr($menu_padding) ?>">
        <div class="container custom-container">
            <div class="row">
                <div class="col-12">
                    <div class="tgmenu__wrap">
                        <nav class="tgmenu__nav">
                            <div class="logo">
                                <?php apexa_header_logo(); ?>
                            </div>
                            <div class="tgmenu__navbar-wrap tgmenu__main-menu d-none d-lg-flex">
                                <?php apexa_header_menu(); ?>
                            </div>

                            <div class="tgmenu__action d-none d-md-block">
                                <ul class="list-wrap">
                                    <?php if (!empty($apexa_show_header_search)) : ?>
                                        <li class="header-search">
                                            <a href="javascript:void(0)" class="search-open-btn">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="none">
                                                    <path d="M19 19.0002L14.657 14.6572M14.657 14.6572C15.3999 13.9143 15.9892 13.0324 16.3912 12.0618C16.7933 11.0911 17.0002 10.0508 17.0002 9.00021C17.0002 7.9496 16.7933 6.90929 16.3913 5.93866C15.9892 4.96803 15.3999 4.08609 14.657 3.34321C13.9141 2.60032 13.0322 2.01103 12.0616 1.60898C11.0909 1.20693 10.0506 1 9.00002 1C7.94942 1 6.90911 1.20693 5.93848 1.60898C4.96785 2.01103 4.08591 2.60032 3.34302 3.34321C1.84269 4.84354 0.999817 6.87842 0.999817 9.00021C0.999817 11.122 1.84269 13.1569 3.34302 14.6572C4.84335 16.1575 6.87824 17.0004 9.00002 17.0004C11.1218 17.0004 13.1567 16.1575 14.657 14.6572Z" stroke="currentcolor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if (!empty($apexa_show_offcanvas)) : ?>
                                        <li class="offCanvas-menu">
                                            <a href="javascript:void(0)" class="menu-tigger">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 18 18" fill="none">
                                                    <path d="M0 2C0 0.895431 0.895431 0 2 0C3.10457 0 4 0.895431 4 2C4 3.10457 3.10457 4 2 4C0.895431 4 0 3.10457 0 2Z" fill="currentcolor" />
                                                    <path d="M0 9C0 7.89543 0.895431 7 2 7C3.10457 7 4 7.89543 4 9C4 10.1046 3.10457 11 2 11C0.895431 11 0 10.1046 0 9Z" fill="currentcolor" />
                                                    <path d="M0 16C0 14.8954 0.895431 14 2 14C3.10457 14 4 14.8954 4 16C4 17.1046 3.10457 18 2 18C0.895431 18 0 17.1046 0 16Z" fill="currentcolor" />
                                                    <path d="M7 2C7 0.895431 7.89543 0 9 0C10.1046 0 11 0.895431 11 2C11 3.10457 10.1046 4 9 4C7.89543 4 7 3.10457 7 2Z" fill="currentcolor" />
                                                    <path d="M7 9C7 7.89543 7.89543 7 9 7C10.1046 7 11 7.89543 11 9C11 10.1046 10.1046 11 9 11C7.89543 11 7 10.1046 7 9Z" fill="currentcolor" />
                                                    <path d="M7 16C7 14.8954 7.89543 14 9 14C10.1046 14 11 14.8954 11 16C11 17.1046 10.1046 18 9 18C7.89543 18 7 17.1046 7 16Z" fill="currentcolor" />
                                                    <path d="M14 2C14 0.895431 14.8954 0 16 0C17.1046 0 18 0.895431 18 2C18 3.10457 17.1046 4 16 4C14.8954 4 14 3.10457 14 2Z" fill="currentcolor" />
                                                    <path d="M14 9C14 7.89543 14.8954 7 16 7C17.1046 7 18 7.89543 18 9C18 10.1046 17.1046 11 16 11C14.8954 11 14 10.1046 14 9Z" fill="currentcolor" />
                                                    <path d="M14 16C14 14.8954 14.8954 14 16 14C17.1046 14 18 14.8954 18 16C18 17.1046 17.1046 18 16 18C14.8954 18 14 17.1046 14 16Z" fill="currentcolor" />
                                                </svg>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if (!empty($apexa_show_header_button)) : ?>
                                        <li class="header-btn"><a href="<?php echo esc_url($apexa_header_btn_url) ?>" class="btn"><?php echo esc_html($apexa_header_btn_text); ?></a></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            <?php if (has_nav_menu('main-menu')) { ?>
                                <div class="mobile-nav-toggler">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 18 18" fill="none">
                                        <path d="M0 2C0 0.895431 0.895431 0 2 0C3.10457 0 4 0.895431 4 2C4 3.10457 3.10457 4 2 4C0.895431 4 0 3.10457 0 2Z" fill="currentcolor" />
                                        <path d="M0 9C0 7.89543 0.895431 7 2 7C3.10457 7 4 7.89543 4 9C4 10.1046 3.10457 11 2 11C0.895431 11 0 10.1046 0 9Z" fill="currentcolor" />
                                        <path d="M0 16C0 14.8954 0.895431 14 2 14C3.10457 14 4 14.8954 4 16C4 17.1046 3.10457 18 2 18C0.895431 18 0 17.1046 0 16Z" fill="currentcolor" />
                                        <path d="M7 2C7 0.895431 7.89543 0 9 0C10.1046 0 11 0.895431 11 2C11 3.10457 10.1046 4 9 4C7.89543 4 7 3.10457 7 2Z" fill="currentcolor" />
                                        <path d="M7 9C7 7.89543 7.89543 7 9 7C10.1046 7 11 7.89543 11 9C11 10.1046 10.1046 11 9 11C7.89543 11 7 10.1046 7 9Z" fill="currentcolor" />
                                        <path d="M7 16C7 14.8954 7.89543 14 9 14C10.1046 14 11 14.8954 11 16C11 17.1046 10.1046 18 9 18C7.89543 18 7 17.1046 7 16Z" fill="currentcolor" />
                                        <path d="M14 2C14 0.895431 14.8954 0 16 0C17.1046 0 18 0.895431 18 2C18 3.10457 17.1046 4 16 4C14.8954 4 14 3.10457 14 2Z" fill="currentcolor" />
                                        <path d="M14 9C14 7.89543 14.8954 7 16 7C17.1046 7 18 7.89543 18 9C18 10.1046 17.1046 11 16 11C14.8954 11 14 10.1046 14 9Z" fill="currentcolor" />
                                        <path d="M14 16C14 14.8954 14.8954 14 16 14C17.1046 14 18 14.8954 18 16C18 17.1046 17.1046 18 16 18C14.8954 18 14 17.1046 14 16Z" fill="currentcolor" />
                                    </svg>
                                </div>
                            <?php } ?>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Menu  -->
    <?php get_template_part('template-parts/header/mobile-menu'); ?>
    <!-- End Mobile Menu -->

    <?php if (!empty($apexa_show_header_search)) : ?>
        <!-- header-search -->
        <?php get_template_part('template-parts/header/header-search'); ?>
        <!-- header-search-end -->
    <?php endif; ?>

    <?php if (!empty($apexa_show_offcanvas)) : ?>
        <!-- offCanvas-menu -->
        <?php get_template_part('template-parts/header/header-offcanvas'); ?>
        <!-- offCanvas-menu-end -->
    <?php endif; ?>

</header>
<!-- header-area-end -->