<?php

/**
 * Template part for displaying header layout Six
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package apexa
 */

// Header Settings
$apexa_show_sticky_header = get_theme_mod('apexa_show_sticky_header', false);
$sticky_header = $apexa_show_sticky_header ? 'sticky-header' : 'sticky-default';
$sticky_height = $apexa_show_sticky_header ? '' : 'd-none';

$menu_padding = has_nav_menu('main-menu') ? 'apexa-menu-has-showing' : 'apexa-menu-not-showing';

// Header Top
$apexa_show_header_top = get_theme_mod('apexa_show_header_top', false);
$apexa_header_phone_text = get_theme_mod('apexa_header_phone_text', __('+123 9898 500', 'apexa'));
$apexa_header_location = get_theme_mod('apexa_header_location', __('256 Avenue, Mark Street, Newyork City', 'apexa'));
$apexa_header_email_text = get_theme_mod('apexa_header_email_text', __('info@apexa.com', 'apexa'));
$apexa_header_date = get_theme_mod('apexa_header_date', __('Mon-Fri: 10:00am - 09:00pm', 'apexa'));

// Header Search
$apexa_show_header_search = get_theme_mod('apexa_show_header_search', false);

// Header Button 01
$apexa_show_header_button = get_theme_mod('apexa_show_header_button', false);
$apexa_header_btn_text = get_theme_mod('apexa_header_btn_text', __('let’s Talk', 'apexa'));
$apexa_header_btn_url = get_theme_mod('apexa_header_btn_url', __('#', 'apexa'));

// Header Button 02
$apexa_show_header_button02 = get_theme_mod('apexa_show_header_button02', false);
$apexa_header_btn_text02 = get_theme_mod('apexa_header_btn_text02', __('Free Trial', 'apexa'));
$apexa_header_btn_url02 = get_theme_mod('apexa_header_btn_url02', __('#', 'apexa'));

// Offcanvas Menu
$apexa_show_offcanvas = get_theme_mod('apexa_show_offcanvas', false);

?>


<!-- header-area -->
<header class="tg-header__style-five transparent-header">
    <div id="<?php echo esc_attr($sticky_header); ?>" class="tg-header__area tg-header__area-five">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="tgmenu__wrap">
                        <nav class="tgmenu__nav">
                            <div class="logo">
                                <?php apexa_header_logo(); ?>
                            </div>
                            <div class="tgmenu__navbar-wrap tgmenu__main-menu d-none d-lg-flex">
                                <?php apexa_header_menu(); ?>
                            </div>
                            <div class="tgmenu__action tgmenu__action-five d-none d-md-block">
                                <ul class="list-wrap">
                                    <?php if (!empty($apexa_show_header_button)) : ?>
                                        <li class="header-btn-two">
                                            <a href="<?php echo esc_url($apexa_header_btn_url) ?>" class="btn border-btn"><?php echo esc_html($apexa_header_btn_text); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if (!empty($apexa_show_header_button02)) : ?>
                                        <li class="header-btn">
                                            <a href="<?php echo esc_url($apexa_header_btn_url02) ?>" class="btn"><?php echo esc_html($apexa_header_btn_text02); ?></a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            <?php if (has_nav_menu('main-menu')) { ?>
                                <div class="mobile-nav-toggler mobile-nav-toggler-two">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 18 18" fill="none">
                                        <path d="M0 2C0 0.895431 0.895431 0 2 0C3.10457 0 4 0.895431 4 2C4 3.10457 3.10457 4 2 4C0.895431 4 0 3.10457 0 2Z" fill="currentcolor" />
                                        <path d="M0 9C0 7.89543 0.895431 7 2 7C3.10457 7 4 7.89543 4 9C4 10.1046 3.10457 11 2 11C0.895431 11 0 10.1046 0 9Z" fill="currentcolor" />
                                        <path d="M0 16C0 14.8954 0.895431 14 2 14C3.10457 14 4 14.8954 4 16C4 17.1046 3.10457 18 2 18C0.895431 18 0 17.1046 0 16Z" fill="currentcolor" />
                                        <path d="M7 2C7 0.895431 7.89543 0 9 0C10.1046 0 11 0.895431 11 2C11 3.10457 10.1046 4 9 4C7.89543 4 7 3.10457 7 2Z" fill="currentcolor" />
                                        <path d="M7 9C7 7.89543 7.89543 7 9 7C10.1046 7 11 7.89543 11 9C11 10.1046 10.1046 11 9 11C7.89543 11 7 10.1046 7 9Z" fill="currentcolor" />
                                        <path d="M7 16C7 14.8954 7.89543 14 9 14C10.1046 14 11 14.8954 11 16C11 17.1046 10.1046 18 9 18C7.89543 18 7 17.1046 7 16Z" fill="currentcolor" />
                                        <path d="M14 2C14 0.895431 14.8954 0 16 0C17.1046 0 18 0.895431 18 2C18 3.10457 17.1046 4 16 4C14.8954 4 14 3.10457 14 2Z" fill="currentcolor" />
                                        <path d="M14 9C14 7.89543 14.8954 7 16 7C17.1046 7 18 7.89543 18 9C18 10.1046 17.1046 11 16 11C14.8954 11 14 10.1046 14 9Z" fill="currentcolor" />
                                        <path d="M14 16C14 14.8954 14.8954 14 16 14C17.1046 14 18 14.8954 18 16C18 17.1046 17.1046 18 16 18C14.8954 18 14 17.1046 14 16Z" fill="currentcolor" />
                                    </svg>
                                </div>
                            <?php } ?>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Menu  -->
    <?php get_template_part('template-parts/header/mobile-menu'); ?>
    <!-- End Mobile Menu -->

</header>
<!-- header-area-end -->