<?php

/**
 * Template part for displaying offcanvas menu
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package apexa
 */

// Offcanvas Menu
$offcanvas_address_title = get_theme_mod('offcanvas_address_title', __('Office Address', 'apexa'));
$offcanvas_address_text = get_theme_mod('offcanvas_address_text', __('123/A, Miranda City Likaoli
Prikano, Dope', 'apexa'));
$offcanvas_phone_title = get_theme_mod('offcanvas_phone_title', __('Phone Number', 'apexa'));
$offcanvas_phone_text = get_theme_mod('offcanvas_phone_text', __('+0989 7876 9865 9', 'apexa'));
$offcanvas_email_title = get_theme_mod('offcanvas_email_title', __('Email Address', 'apexa'));
$offcanvas_email_text = get_theme_mod('offcanvas_email_text', __('info@example.com', 'apexa'));

$apexa_show_offcanvas_social = get_theme_mod('apexa_show_offcanvas_social', false);
$offcanvas_fb = get_theme_mod('offcanvas_fb', __('#', 'apexa'));
$offcanvas_twitter = get_theme_mod('offcanvas_twitter', __('#', 'apexa'));
$offcanvas_instagram = get_theme_mod('offcanvas_instagram', __('#', 'apexa'));
$offcanvas_pinterest = get_theme_mod('offcanvas_pinterest', __('#', 'apexa'));

?>


<div class="offCanvas__info">
    <div class="offCanvas__close-icon menu-close">
        <button><i class="far fa-window-close"></i></button>
    </div>
    <div class="offCanvas__logo mb-30">
        <?php apexa_header_logo(); ?>
    </div>
    <div class="offCanvas__side-info mb-30">
        <?php if (!empty($offcanvas_address_text)) : ?>
            <div class="contact-list mb-30">
                <h4><?php echo esc_html($offcanvas_address_title) ?></h4>
                <p><?php echo wp_kses_post($offcanvas_address_text); ?></p>
            </div>
        <?php endif; ?>

        <?php if (!empty($offcanvas_phone_text)) : ?>
            <div class="contact-list mb-30">
                <h4><?php echo esc_html($offcanvas_phone_title) ?></h4>
                <p><?php echo wp_kses_post($offcanvas_phone_text); ?></p>
            </div>
        <?php endif; ?>

        <?php if (!empty($offcanvas_email_text)) : ?>
            <div class="contact-list mb-30">
                <h4><?php echo esc_html($offcanvas_email_title) ?></h4>
                <p><?php echo wp_kses_post($offcanvas_email_text); ?></p>
            </div>
        <?php endif; ?>
    </div>

    <?php if (!empty($apexa_show_offcanvas_social)) : ?>
        <div class="offCanvas__social-icon mt-30">
            <?php if (!empty($offcanvas_fb)) : ?>
                <a href="<?php echo esc_url($offcanvas_fb); ?>"><i class="fab fa-facebook-f"></i></a>
            <?php endif; ?>

            <?php if (!empty($offcanvas_twitter)) : ?>
                <a href="<?php echo esc_url($offcanvas_twitter); ?>"><i class="fab fa-twitter"></i></a>
            <?php endif; ?>

            <?php if (!empty($offcanvas_instagram)) : ?>
                <a href="<?php echo esc_url($offcanvas_instagram); ?>"><i class="fab fa-instagram"></i></a>
            <?php endif; ?>

            <?php if (!empty($offcanvas_pinterest)) : ?>
                <a href="<?php echo esc_url($offcanvas_pinterest); ?>"><i class="fab fa-pinterest-p"></i></a>
            <?php endif; ?>
        </div>
    <?php endif; ?>

</div>
<div class="offCanvas__overly"></div>