<?php

/**
 * Template part for displaying Mobile Menu
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package apexa
 */

// Mobile Menu
$apexa_show_mobile_search = get_theme_mod('apexa_show_mobile_search', false);
$apexa_show_mobile_social = get_theme_mod('apexa_show_mobile_social', false);

// Mobile Contact
$apexa_show_mobile_contact = get_theme_mod('apexa_show_mobile_contact', false);
$apexa_mobile_phone_text = get_theme_mod('apexa_mobile_phone_text', __('+123 9898 500', 'apexa'));
$apexa_mobile_email_text = get_theme_mod('apexa_mobile_email_text', __('info@apexa.com', 'apexa'));

?>


<div class="tgmobile__menu">
    <nav class="tgmobile__menu-box">
        <div class="close-btn"><i class="fas fa-times"></i></div>
        <div class="nav-logo">
            <?php apexa_header_logo(); ?>
        </div>
        <?php if (!empty($apexa_show_mobile_search)) : ?>
            <div class="tgmobile__search">
                <form method="get" action="<?php print esc_url(home_url('/')); ?>">
                    <input type="text" name="s" value="<?php print esc_attr(get_search_query()) ?>" placeholder="<?php print esc_attr__('Search here...', 'apexa'); ?>">
                    <button><i class="fas fa-search"></i></button>
                </form>
            </div>
        <?php endif; ?>
        <div class="tgmobile__menu-outer">
            <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
        </div>
        <div class="tgmobile__menu-bottom">
            <?php if (!empty($apexa_show_mobile_contact)) : ?>
                <div class="contact-info">
                    <ul class="list-wrap">
                        <?php if (!empty($apexa_mobile_email_text)) : ?>
                            <li><a href="mailto:<?php echo esc_attr($apexa_mobile_email_text); ?>"><?php echo esc_html($apexa_mobile_email_text); ?></a></li>
                        <?php endif; ?>
                        <?php if (!empty($apexa_mobile_phone_text)) : ?>
                            <li><a href="tel:<?php echo esc_attr($apexa_mobile_phone_text); ?>"><?php echo esc_html($apexa_mobile_phone_text); ?></a></li>
                        <?php endif; ?>
                    </ul>
                </div>
            <?php endif; ?>
            <?php if (!empty($apexa_show_mobile_social)) : ?>
                <div class="social-links">
                    <?php apexa_mobile_social_profiles(); ?>
                </div>
            <?php endif; ?>
        </div>
    </nav>
</div>
<div class="tgmobile__menu-backdrop"></div>